/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;


public class ConnectorsMeta {
    /**
     * The provider key
     */
    @JsonProperty("provider")
    private String provider;

    /**
     * The provider human-readable label
     */
    @JsonProperty("provider_name")
    private String providerName;

    /**
     * The provider service category
     */
    @JsonProperty("category")
    private ConnectorsMetaCategory category;

    /**
     * Whether this provider has been enabled on the integrations page for the current project
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("active")
    private JsonNullable<Boolean> active;


    @JsonProperty("models")
    private Map<String, Object> models;

    /**
     * Resources for this provider, such as image assets
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("resources")
    private JsonNullable<? extends Resources> resources;

    @JsonCreator
    public ConnectorsMeta(
            @JsonProperty("provider") String provider,
            @JsonProperty("provider_name") String providerName,
            @JsonProperty("category") ConnectorsMetaCategory category,
            @JsonProperty("active") JsonNullable<Boolean> active,
            @JsonProperty("models") Map<String, Object> models,
            @JsonProperty("resources") JsonNullable<? extends Resources> resources) {
        Utils.checkNotNull(provider, "provider");
        Utils.checkNotNull(providerName, "providerName");
        Utils.checkNotNull(category, "category");
        Utils.checkNotNull(active, "active");
        models = Utils.emptyMapIfNull(models);
        Utils.checkNotNull(models, "models");
        Utils.checkNotNull(resources, "resources");
        this.provider = provider;
        this.providerName = providerName;
        this.category = category;
        this.active = active;
        this.models = models;
        this.resources = resources;
    }
    
    public ConnectorsMeta(
            String provider,
            String providerName,
            ConnectorsMetaCategory category,
            Map<String, Object> models) {
        this(provider, providerName, category,
            JsonNullable.undefined(), models, JsonNullable.undefined());
    }

    /**
     * The provider key
     */
    @JsonIgnore
    public String provider() {
        return provider;
    }

    /**
     * The provider human-readable label
     */
    @JsonIgnore
    public String providerName() {
        return providerName;
    }

    /**
     * The provider service category
     */
    @JsonIgnore
    public ConnectorsMetaCategory category() {
        return category;
    }

    /**
     * Whether this provider has been enabled on the integrations page for the current project
     */
    @JsonIgnore
    public JsonNullable<Boolean> active() {
        return active;
    }

    @JsonIgnore
    public Map<String, Object> models() {
        return models;
    }

    /**
     * Resources for this provider, such as image assets
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Resources> resources() {
        return (JsonNullable<Resources>) resources;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The provider key
     */
    public ConnectorsMeta withProvider(String provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = provider;
        return this;
    }

    /**
     * The provider human-readable label
     */
    public ConnectorsMeta withProviderName(String providerName) {
        Utils.checkNotNull(providerName, "providerName");
        this.providerName = providerName;
        return this;
    }

    /**
     * The provider service category
     */
    public ConnectorsMeta withCategory(ConnectorsMetaCategory category) {
        Utils.checkNotNull(category, "category");
        this.category = category;
        return this;
    }

    /**
     * Whether this provider has been enabled on the integrations page for the current project
     */
    public ConnectorsMeta withActive(boolean active) {
        Utils.checkNotNull(active, "active");
        this.active = JsonNullable.of(active);
        return this;
    }

    /**
     * Whether this provider has been enabled on the integrations page for the current project
     */
    public ConnectorsMeta withActive(JsonNullable<Boolean> active) {
        Utils.checkNotNull(active, "active");
        this.active = active;
        return this;
    }

    public ConnectorsMeta withModels(Map<String, Object> models) {
        Utils.checkNotNull(models, "models");
        this.models = models;
        return this;
    }

    /**
     * Resources for this provider, such as image assets
     */
    public ConnectorsMeta withResources(Resources resources) {
        Utils.checkNotNull(resources, "resources");
        this.resources = JsonNullable.of(resources);
        return this;
    }

    /**
     * Resources for this provider, such as image assets
     */
    public ConnectorsMeta withResources(JsonNullable<? extends Resources> resources) {
        Utils.checkNotNull(resources, "resources");
        this.resources = resources;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ConnectorsMeta other = (ConnectorsMeta) o;
        return 
            Utils.enhancedDeepEquals(this.provider, other.provider) &&
            Utils.enhancedDeepEquals(this.providerName, other.providerName) &&
            Utils.enhancedDeepEquals(this.category, other.category) &&
            Utils.enhancedDeepEquals(this.active, other.active) &&
            Utils.enhancedDeepEquals(this.models, other.models) &&
            Utils.enhancedDeepEquals(this.resources, other.resources);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            provider, providerName, category,
            active, models, resources);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ConnectorsMeta.class,
                "provider", provider,
                "providerName", providerName,
                "category", category,
                "active", active,
                "models", models,
                "resources", resources);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String provider;

        private String providerName;

        private ConnectorsMetaCategory category;

        private JsonNullable<Boolean> active = JsonNullable.undefined();

        private Map<String, Object> models;

        private JsonNullable<? extends Resources> resources = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The provider key
         */
        public Builder provider(String provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = provider;
            return this;
        }


        /**
         * The provider human-readable label
         */
        public Builder providerName(String providerName) {
            Utils.checkNotNull(providerName, "providerName");
            this.providerName = providerName;
            return this;
        }


        /**
         * The provider service category
         */
        public Builder category(ConnectorsMetaCategory category) {
            Utils.checkNotNull(category, "category");
            this.category = category;
            return this;
        }


        /**
         * Whether this provider has been enabled on the integrations page for the current project
         */
        public Builder active(boolean active) {
            Utils.checkNotNull(active, "active");
            this.active = JsonNullable.of(active);
            return this;
        }

        /**
         * Whether this provider has been enabled on the integrations page for the current project
         */
        public Builder active(JsonNullable<Boolean> active) {
            Utils.checkNotNull(active, "active");
            this.active = active;
            return this;
        }


        public Builder models(Map<String, Object> models) {
            Utils.checkNotNull(models, "models");
            this.models = models;
            return this;
        }


        /**
         * Resources for this provider, such as image assets
         */
        public Builder resources(Resources resources) {
            Utils.checkNotNull(resources, "resources");
            this.resources = JsonNullable.of(resources);
            return this;
        }

        /**
         * Resources for this provider, such as image assets
         */
        public Builder resources(JsonNullable<? extends Resources> resources) {
            Utils.checkNotNull(resources, "resources");
            this.resources = resources;
            return this;
        }

        public ConnectorsMeta build() {

            return new ConnectorsMeta(
                provider, providerName, category,
                active, models, resources);
        }

    }
}
