/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.stackone.stackone_client_java.models.errors.AsyncSDKError;
import com.stackone.stackone_client_java.models.errors.StackOneError;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import jakarta.annotation.Nullable;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class UnauthorizedResponse
extends StackOneError {
    @Nullable
    private final Data data;
    @Nullable
    private final Throwable deserializationException;

    public UnauthorizedResponse(int code, byte[] body, HttpResponse<?> rawResponse, @Nullable Data data, @Nullable Throwable deserializationException) {
        super("API error occurred", code, body, rawResponse, null);
        this.data = data;
        this.deserializationException = deserializationException;
    }

    public static UnauthorizedResponse from(HttpResponse<InputStream> response) {
        try {
            byte[] bytes = Utils.extractByteArrayFromBody(response);
            Data data = (Data)Utils.mapper().readValue(bytes, Data.class);
            return new UnauthorizedResponse(response.statusCode(), bytes, response, data, null);
        }
        catch (Exception e) {
            return new UnauthorizedResponse(response.statusCode(), null, response, null, (Throwable)e);
        }
    }

    public static CompletableFuture<UnauthorizedResponse> fromAsync(HttpResponse<Blob> response) {
        return response.body().toByteArray().handle((bytes, err) -> {
            if (err != null) {
                throw new AsyncSDKError("Error reading response body: " + err.getMessage(), response.statusCode(), null, response, (Throwable)err);
            }
            try {
                return new UnauthorizedResponse(response.statusCode(), (byte[])bytes, response, (Data)Utils.mapper().readValue(bytes, (TypeReference)new TypeReference<Data>(){}), null);
            }
            catch (Exception e) {
                return new UnauthorizedResponse(response.statusCode(), (byte[])bytes, response, null, (Throwable)e);
            }
        });
    }

    @Deprecated
    public Optional<Double> statusCode() {
        return this.data().map(Data::statusCode);
    }

    @Deprecated
    public Optional<OffsetDateTime> timestamp() {
        return this.data().map(Data::timestamp);
    }

    public Optional<Data> data() {
        return Optional.ofNullable(this.data);
    }

    public Optional<Throwable> deserializationException() {
        return Optional.ofNullable(this.deserializationException);
    }

    public static class Data {
        @JsonProperty(value="statusCode")
        private double statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="timestamp")
        private OffsetDateTime timestamp;

        @JsonCreator
        public Data(@JsonProperty(value="statusCode") double statusCode, @JsonProperty(value="message") String message, @JsonProperty(value="timestamp") OffsetDateTime timestamp) {
            Utils.checkNotNull(statusCode, "statusCode");
            Utils.checkNotNull(message, "message");
            Utils.checkNotNull(timestamp, "timestamp");
            this.statusCode = statusCode;
            this.message = message;
            this.timestamp = timestamp;
        }

        @JsonIgnore
        public double statusCode() {
            return this.statusCode;
        }

        @JsonIgnore
        public String message() {
            return this.message;
        }

        @JsonIgnore
        public OffsetDateTime timestamp() {
            return this.timestamp;
        }

        public static Builder builder() {
            return new Builder();
        }

        public Data withStatusCode(double statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Data withMessage(String message) {
            Utils.checkNotNull(message, "message");
            this.message = message;
            return this;
        }

        public Data withTimestamp(OffsetDateTime timestamp) {
            Utils.checkNotNull(timestamp, "timestamp");
            this.timestamp = timestamp;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Data other = (Data)o;
            return Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.message, other.message) && Utils.enhancedDeepEquals(this.timestamp, other.timestamp);
        }

        public int hashCode() {
            return Utils.enhancedHash(this.statusCode, this.message, this.timestamp);
        }

        public String toString() {
            return Utils.toString(Data.class, "statusCode", this.statusCode, "message", this.message, "timestamp", this.timestamp);
        }

        public static final class Builder {
            private Double statusCode;
            private String message;
            private OffsetDateTime timestamp;

            private Builder() {
            }

            public Builder statusCode(double statusCode) {
                Utils.checkNotNull(statusCode, "statusCode");
                this.statusCode = statusCode;
                return this;
            }

            public Builder message(String message) {
                Utils.checkNotNull(message, "message");
                this.message = message;
                return this;
            }

            public Builder timestamp(OffsetDateTime timestamp) {
                Utils.checkNotNull(timestamp, "timestamp");
                this.timestamp = timestamp;
                return this;
            }

            public Data build() {
                return new Data(this.statusCode, this.message, this.timestamp);
            }
        }
    }
}

