/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class InterviewPartValue {
    public static final InterviewPartValue SCREENING = new InterviewPartValue("screening");
    public static final InterviewPartValue LUNCH = new InterviewPartValue("lunch");
    public static final InterviewPartValue ON_SITE = new InterviewPartValue("on_site");
    public static final InterviewPartValue PRESENTATION = new InterviewPartValue("presentation");
    public static final InterviewPartValue SELL = new InterviewPartValue("sell");
    public static final InterviewPartValue CULTURE = new InterviewPartValue("culture");
    public static final InterviewPartValue INFORMAL = new InterviewPartValue("informal");
    public static final InterviewPartValue TEST = new InterviewPartValue("test");
    public static final InterviewPartValue PHONE = new InterviewPartValue("phone");
    public static final InterviewPartValue VIDEO = new InterviewPartValue("video");
    public static final InterviewPartValue UNMAPPED_VALUE = new InterviewPartValue("unmapped_value");
    private static final Map<String, InterviewPartValue> values = InterviewPartValue.createValuesMap();
    private static final Map<String, InterviewPartValueEnum> enums = InterviewPartValue.createEnumsMap();
    private final String value;

    private InterviewPartValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InterviewPartValue of(String value) {
        Class<InterviewPartValue> clazz = InterviewPartValue.class;
        synchronized (InterviewPartValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new InterviewPartValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<InterviewPartValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InterviewPartValue other = (InterviewPartValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "InterviewPartValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InterviewPartValue[] values() {
        Class<InterviewPartValue> clazz = InterviewPartValue.class;
        synchronized (InterviewPartValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new InterviewPartValue[0]);
        }
    }

    private static final Map<String, InterviewPartValue> createValuesMap() {
        LinkedHashMap<String, InterviewPartValue> map = new LinkedHashMap<String, InterviewPartValue>();
        map.put("screening", SCREENING);
        map.put("lunch", LUNCH);
        map.put("on_site", ON_SITE);
        map.put("presentation", PRESENTATION);
        map.put("sell", SELL);
        map.put("culture", CULTURE);
        map.put("informal", INFORMAL);
        map.put("test", TEST);
        map.put("phone", PHONE);
        map.put("video", VIDEO);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, InterviewPartValueEnum> createEnumsMap() {
        HashMap<String, InterviewPartValueEnum> map = new HashMap<String, InterviewPartValueEnum>();
        map.put("screening", InterviewPartValueEnum.SCREENING);
        map.put("lunch", InterviewPartValueEnum.LUNCH);
        map.put("on_site", InterviewPartValueEnum.ON_SITE);
        map.put("presentation", InterviewPartValueEnum.PRESENTATION);
        map.put("sell", InterviewPartValueEnum.SELL);
        map.put("culture", InterviewPartValueEnum.CULTURE);
        map.put("informal", InterviewPartValueEnum.INFORMAL);
        map.put("test", InterviewPartValueEnum.TEST);
        map.put("phone", InterviewPartValueEnum.PHONE);
        map.put("video", InterviewPartValueEnum.VIDEO);
        map.put("unmapped_value", InterviewPartValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum InterviewPartValueEnum {
        SCREENING("screening"),
        LUNCH("lunch"),
        ON_SITE("on_site"),
        PRESENTATION("presentation"),
        SELL("sell"),
        CULTURE("culture"),
        INFORMAL("informal"),
        TEST("test"),
        PHONE("phone"),
        VIDEO("video"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private InterviewPartValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<InterviewPartValue> {
        protected _Deserializer() {
            super(InterviewPartValue.class);
        }

        public InterviewPartValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return InterviewPartValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<InterviewPartValue> {
        protected _Serializer() {
            super(InterviewPartValue.class);
        }

        public void serialize(InterviewPartValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

