/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.JsonRpcMessageDto;
import com.stackone.stackone_client_java.models.operations.StackoneMcpPostRequest;
import com.stackone.stackone_client_java.models.operations.StackoneMcpPostResponse;
import com.stackone.stackone_client_java.models.operations.StackoneMcpPostSecurity;
import com.stackone.stackone_client_java.operations.StackoneMcpPost;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class StackoneMcpPostRequestBuilder {
    private StackoneMcpPostSecurity security;
    private Optional<String> xAccountId = Optional.empty();
    private Optional<? extends Object> xAccountIdQueryParameter = Optional.empty();
    private Optional<String> mcpSessionId = Optional.empty();
    private JsonRpcMessageDto jsonRpcMessageDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public StackoneMcpPostRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public StackoneMcpPostRequestBuilder security(StackoneMcpPostSecurity security) {
        Utils.checkNotNull(security, "security");
        this.security = security;
        return this;
    }

    public StackoneMcpPostRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = Optional.of(xAccountId);
        return this;
    }

    public StackoneMcpPostRequestBuilder xAccountId(Optional<String> xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public StackoneMcpPostRequestBuilder xAccountIdQueryParameter(Object xAccountIdQueryParameter) {
        Utils.checkNotNull(xAccountIdQueryParameter, "xAccountIdQueryParameter");
        this.xAccountIdQueryParameter = Optional.of(xAccountIdQueryParameter);
        return this;
    }

    public StackoneMcpPostRequestBuilder xAccountIdQueryParameter(Optional<? extends Object> xAccountIdQueryParameter) {
        Utils.checkNotNull(xAccountIdQueryParameter, "xAccountIdQueryParameter");
        this.xAccountIdQueryParameter = xAccountIdQueryParameter;
        return this;
    }

    public StackoneMcpPostRequestBuilder mcpSessionId(String mcpSessionId) {
        Utils.checkNotNull(mcpSessionId, "mcpSessionId");
        this.mcpSessionId = Optional.of(mcpSessionId);
        return this;
    }

    public StackoneMcpPostRequestBuilder mcpSessionId(Optional<String> mcpSessionId) {
        Utils.checkNotNull(mcpSessionId, "mcpSessionId");
        this.mcpSessionId = mcpSessionId;
        return this;
    }

    public StackoneMcpPostRequestBuilder jsonRpcMessageDto(JsonRpcMessageDto jsonRpcMessageDto) {
        Utils.checkNotNull(jsonRpcMessageDto, "jsonRpcMessageDto");
        this.jsonRpcMessageDto = jsonRpcMessageDto;
        return this;
    }

    public StackoneMcpPostRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public StackoneMcpPostRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private StackoneMcpPostRequest buildRequest() {
        StackoneMcpPostRequest request = new StackoneMcpPostRequest(this.xAccountId, this.xAccountIdQueryParameter, this.mcpSessionId, this.jsonRpcMessageDto);
        return request;
    }

    public StackoneMcpPostResponse call() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        StackoneMcpPost.Sync operation = new StackoneMcpPost.Sync(this.sdkConfiguration, this.security, options, this._headers);
        StackoneMcpPostRequest request = this.buildRequest();
        return (StackoneMcpPostResponse)operation.handleResponse(operation.doRequest(request));
    }
}

