/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.RequestOperation;

import com.stackone.stackone_client_java.models.components.ActionBuildDto;
import com.stackone.stackone_client_java.models.components.ActionSearchDto;
import com.stackone.stackone_client_java.models.components.ActionsRpcRequestDto;
import com.stackone.stackone_client_java.models.operations.StackoneBuildActionEmbeddingsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneBuildActionEmbeddingsResponse;
import com.stackone.stackone_client_java.models.operations.StackoneListActionsMetaRequest;
import com.stackone.stackone_client_java.models.operations.StackoneListActionsMetaRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneListActionsMetaResponse;
import com.stackone.stackone_client_java.models.operations.StackoneRpcActionRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneRpcActionResponse;
import com.stackone.stackone_client_java.models.operations.StackoneSearchActionsRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneSearchActionsResponse;
import com.stackone.stackone_client_java.operations.StackoneBuildActionEmbeddings;
import com.stackone.stackone_client_java.operations.StackoneListActionsMeta;
import com.stackone.stackone_client_java.operations.StackoneRpcAction;
import com.stackone.stackone_client_java.operations.StackoneSearchActions;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import java.util.Optional;

/**
 * Retrieve Actions metadata and definitions.
 */
public class Actions {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final AsyncActions asyncSDK;

    Actions(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.asyncSDK = new AsyncActions(this, sdkConfiguration);
    }

    /**
     * Switches to the async SDK.
     * 
     * @return The async SDK
     */
    public AsyncActions async() {
        return asyncSDK;
    }

    /**
     * List all actions metadata
     * 
     * <p>Retrieves a list of all actions metadata
     * 
     * @return The call builder
     */
    public StackoneListActionsMetaRequestBuilder listActionsMeta() {
        return new StackoneListActionsMetaRequestBuilder(sdkConfiguration);
    }

    /**
     * List all actions metadata
     * 
     * <p>Retrieves a list of all actions metadata
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneListActionsMetaResponse listActionsMeta(StackoneListActionsMetaRequest request) {
        return listActionsMeta(request, Optional.empty());
    }

    /**
     * List all actions metadata
     * 
     * <p>Retrieves a list of all actions metadata
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneListActionsMetaResponse listActionsMeta(StackoneListActionsMetaRequest request, Optional<Options> options) {
        RequestOperation<StackoneListActionsMetaRequest, StackoneListActionsMetaResponse> operation
              = new StackoneListActionsMeta.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Search connector actions by semantic similarity
     * 
     * @return The call builder
     */
    public StackoneSearchActionsRequestBuilder searchActions() {
        return new StackoneSearchActionsRequestBuilder(sdkConfiguration);
    }

    /**
     * Search connector actions by semantic similarity
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneSearchActionsResponse searchActions(ActionSearchDto request) {
        return searchActions(request, Optional.empty());
    }

    /**
     * Search connector actions by semantic similarity
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneSearchActionsResponse searchActions(ActionSearchDto request, Optional<Options> options) {
        RequestOperation<ActionSearchDto, StackoneSearchActionsResponse> operation
              = new StackoneSearchActions.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Rebuild action embeddings for semantic search
     * 
     * @return The call builder
     */
    public StackoneBuildActionEmbeddingsRequestBuilder buildActionEmbeddings() {
        return new StackoneBuildActionEmbeddingsRequestBuilder(sdkConfiguration);
    }

    /**
     * Rebuild action embeddings for semantic search
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneBuildActionEmbeddingsResponse buildActionEmbeddings(ActionBuildDto request) {
        return buildActionEmbeddings(request, Optional.empty());
    }

    /**
     * Rebuild action embeddings for semantic search
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneBuildActionEmbeddingsResponse buildActionEmbeddings(ActionBuildDto request, Optional<Options> options) {
        RequestOperation<ActionBuildDto, StackoneBuildActionEmbeddingsResponse> operation
              = new StackoneBuildActionEmbeddings.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Make an RPC call to an action
     * 
     * <p>Makes a remote procedure call to the specified action
     * 
     * @return The call builder
     */
    public StackoneRpcActionRequestBuilder rpcAction() {
        return new StackoneRpcActionRequestBuilder(sdkConfiguration);
    }

    /**
     * Make an RPC call to an action
     * 
     * <p>Makes a remote procedure call to the specified action
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneRpcActionResponse rpcAction(ActionsRpcRequestDto request) {
        return rpcAction(request, Optional.empty());
    }

    /**
     * Make an RPC call to an action
     * 
     * <p>Makes a remote procedure call to the specified action
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public StackoneRpcActionResponse rpcAction(ActionsRpcRequestDto request, Optional<Options> options) {
        RequestOperation<ActionsRpcRequestDto, StackoneRpcActionResponse> operation
              = new StackoneRpcAction.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

}
