/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * JobPostingValue
 * 
 * <p>The status of the job postings.
 */
public class JobPostingValue {

    public static final JobPostingValue LIVE = new JobPostingValue("live");
    public static final JobPostingValue DRAFT = new JobPostingValue("draft");
    public static final JobPostingValue PENDING = new JobPostingValue("pending");
    public static final JobPostingValue INTERNAL = new JobPostingValue("internal");
    public static final JobPostingValue REJECTED = new JobPostingValue("rejected");
    public static final JobPostingValue CLOSED = new JobPostingValue("closed");
    public static final JobPostingValue ARCHIVED = new JobPostingValue("archived");
    public static final JobPostingValue UNMAPPED_VALUE = new JobPostingValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, JobPostingValue> values = createValuesMap();
    private static final Map<String, JobPostingValueEnum> enums = createEnumsMap();

    private final String value;

    private JobPostingValue(String value) {
        this.value = value;
    }

    /**
     * Returns a JobPostingValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as JobPostingValue
     */ 
    @JsonCreator
    public static JobPostingValue of(String value) {
        synchronized (JobPostingValue.class) {
            return values.computeIfAbsent(value, v -> new JobPostingValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<JobPostingValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        JobPostingValue other = (JobPostingValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "JobPostingValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static JobPostingValue[] values() {
        synchronized (JobPostingValue.class) {
            return values.values().toArray(new JobPostingValue[] {});
        }
    }

    private static final Map<String, JobPostingValue> createValuesMap() {
        Map<String, JobPostingValue> map = new LinkedHashMap<>();
        map.put("live", LIVE);
        map.put("draft", DRAFT);
        map.put("pending", PENDING);
        map.put("internal", INTERNAL);
        map.put("rejected", REJECTED);
        map.put("closed", CLOSED);
        map.put("archived", ARCHIVED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, JobPostingValueEnum> createEnumsMap() {
        Map<String, JobPostingValueEnum> map = new HashMap<>();
        map.put("live", JobPostingValueEnum.LIVE);
        map.put("draft", JobPostingValueEnum.DRAFT);
        map.put("pending", JobPostingValueEnum.PENDING);
        map.put("internal", JobPostingValueEnum.INTERNAL);
        map.put("rejected", JobPostingValueEnum.REJECTED);
        map.put("closed", JobPostingValueEnum.CLOSED);
        map.put("archived", JobPostingValueEnum.ARCHIVED);
        map.put("unmapped_value", JobPostingValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum JobPostingValueEnum {

        LIVE("live"),
        DRAFT("draft"),
        PENDING("pending"),
        INTERNAL("internal"),
        REJECTED("rejected"),
        CLOSED("closed"),
        ARCHIVED("archived"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private JobPostingValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

