/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Wrapper for an "open" enum that can handle unknown values from API responses
 * without runtime errors. Instances are immutable singletons with reference equality.
 * Use {@code asEnum()} for switch expressions.
 */
/**
 * TicketingUserValue
 * 
 * <p>The type of the user.
 */
public class TicketingUserValue {

    public static final TicketingUserValue AGENT = new TicketingUserValue("agent");
    public static final TicketingUserValue CONTACT = new TicketingUserValue("contact");
    public static final TicketingUserValue BOT = new TicketingUserValue("bot");
    public static final TicketingUserValue UNMAPPED_VALUE = new TicketingUserValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, TicketingUserValue> values = createValuesMap();
    private static final Map<String, TicketingUserValueEnum> enums = createEnumsMap();

    private final String value;

    private TicketingUserValue(String value) {
        this.value = value;
    }

    /**
     * Returns a TicketingUserValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as TicketingUserValue
     */ 
    @JsonCreator
    public static TicketingUserValue of(String value) {
        synchronized (TicketingUserValue.class) {
            return values.computeIfAbsent(value, v -> new TicketingUserValue(v));
        }
    }

    @JsonValue
    public String value() {
        return value;
    }

    public Optional<TicketingUserValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        TicketingUserValue other = (TicketingUserValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "TicketingUserValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static TicketingUserValue[] values() {
        synchronized (TicketingUserValue.class) {
            return values.values().toArray(new TicketingUserValue[] {});
        }
    }

    private static final Map<String, TicketingUserValue> createValuesMap() {
        Map<String, TicketingUserValue> map = new LinkedHashMap<>();
        map.put("agent", AGENT);
        map.put("contact", CONTACT);
        map.put("bot", BOT);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TicketingUserValueEnum> createEnumsMap() {
        Map<String, TicketingUserValueEnum> map = new HashMap<>();
        map.put("agent", TicketingUserValueEnum.AGENT);
        map.put("contact", TicketingUserValueEnum.CONTACT);
        map.put("bot", TicketingUserValueEnum.BOT);
        map.put("unmapped_value", TicketingUserValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    
    public enum TicketingUserValueEnum {

        AGENT("agent"),
        CONTACT("contact"),
        BOT("bot"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private TicketingUserValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

