/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.UpdateTaskRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Optional;


public class HrisUpdateEmployeeTaskRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=id")
    private String id;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=subResourceId")
    private String subResourceId;

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;


    @SpeakeasyMetadata("request:mediaType=application/json")
    private UpdateTaskRequestDto updateTaskRequestDto;

    @JsonCreator
    public HrisUpdateEmployeeTaskRequest(
            String xAccountId,
            String id,
            String subResourceId,
            Optional<String> prefer,
            UpdateTaskRequestDto updateTaskRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(subResourceId, "subResourceId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(updateTaskRequestDto, "updateTaskRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.subResourceId = subResourceId;
        this.prefer = prefer;
        this.updateTaskRequestDto = updateTaskRequestDto;
    }
    
    public HrisUpdateEmployeeTaskRequest(
            String xAccountId,
            String id,
            String subResourceId,
            UpdateTaskRequestDto updateTaskRequestDto) {
        this(xAccountId, id, subResourceId,
            Optional.empty(), updateTaskRequestDto);
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    @JsonIgnore
    public String id() {
        return id;
    }

    @JsonIgnore
    public String subResourceId() {
        return subResourceId;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    @JsonIgnore
    public Optional<String> prefer() {
        return prefer;
    }

    @JsonIgnore
    public UpdateTaskRequestDto updateTaskRequestDto() {
        return updateTaskRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public HrisUpdateEmployeeTaskRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public HrisUpdateEmployeeTaskRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public HrisUpdateEmployeeTaskRequest withSubResourceId(String subResourceId) {
        Utils.checkNotNull(subResourceId, "subResourceId");
        this.subResourceId = subResourceId;
        return this;
    }

    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public HrisUpdateEmployeeTaskRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }


    /**
     * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
     * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
     */
    public HrisUpdateEmployeeTaskRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public HrisUpdateEmployeeTaskRequest withUpdateTaskRequestDto(UpdateTaskRequestDto updateTaskRequestDto) {
        Utils.checkNotNull(updateTaskRequestDto, "updateTaskRequestDto");
        this.updateTaskRequestDto = updateTaskRequestDto;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisUpdateEmployeeTaskRequest other = (HrisUpdateEmployeeTaskRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.subResourceId, other.subResourceId) &&
            Utils.enhancedDeepEquals(this.prefer, other.prefer) &&
            Utils.enhancedDeepEquals(this.updateTaskRequestDto, other.updateTaskRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, id, subResourceId,
            prefer, updateTaskRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisUpdateEmployeeTaskRequest.class,
                "xAccountId", xAccountId,
                "id", id,
                "subResourceId", subResourceId,
                "prefer", prefer,
                "updateTaskRequestDto", updateTaskRequestDto);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private String id;

        private String subResourceId;

        private Optional<String> prefer = Optional.empty();

        private UpdateTaskRequestDto updateTaskRequestDto;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        public Builder subResourceId(String subResourceId) {
            Utils.checkNotNull(subResourceId, "subResourceId");
            this.subResourceId = subResourceId;
            return this;
        }


        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        /**
         * Set to "heartbeat" to enable keep-alive newline heartbeats during long-running requests. Response
         * includes Preference-Applied: heartbeat header when honored. (RFC 7240)
         */
        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }


        public Builder updateTaskRequestDto(UpdateTaskRequestDto updateTaskRequestDto) {
            Utils.checkNotNull(updateTaskRequestDto, "updateTaskRequestDto");
            this.updateTaskRequestDto = updateTaskRequestDto;
            return this;
        }

        public HrisUpdateEmployeeTaskRequest build() {

            return new HrisUpdateEmployeeTaskRequest(
                xAccountId, id, subResourceId,
                prefer, updateTaskRequestDto);
        }

    }
}
