/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java;

import com.stackone.stackone_client_java.Accounting;
import com.stackone.stackone_client_java.Accounts;
import com.stackone.stackone_client_java.Actions;
import com.stackone.stackone_client_java.AsyncStackOne;
import com.stackone.stackone_client_java.Ats;
import com.stackone.stackone_client_java.ConnectSessions;
import com.stackone.stackone_client_java.Connectors;
import com.stackone.stackone_client_java.Crm;
import com.stackone.stackone_client_java.Documents;
import com.stackone.stackone_client_java.Hris;
import com.stackone.stackone_client_java.Iam;
import com.stackone.stackone_client_java.Lms;
import com.stackone.stackone_client_java.Marketing;
import com.stackone.stackone_client_java.Mcp;
import com.stackone.stackone_client_java.Messaging;
import com.stackone.stackone_client_java.Proxy;
import com.stackone.stackone_client_java.RequestLogs;
import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.Screening;
import com.stackone.stackone_client_java.SecuritySource;
import com.stackone.stackone_client_java.Ticketing;
import com.stackone.stackone_client_java.models.components.Security;
import com.stackone.stackone_client_java.utils.HTTPClient;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Hook;
import com.stackone.stackone_client_java.utils.Hooks;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

public class StackOne {
    private static final Headers _headers = Headers.EMPTY;
    public static final String[] SERVERS = new String[]{"https://api.stackone.com"};
    private final ConnectSessions connectSessions;
    private final Accounts accounts;
    private final RequestLogs requestLogs;
    private final Connectors connectors;
    private final Mcp mcp;
    private final Proxy proxy;
    private final Actions actions;
    private final Hris hris;
    private final Ats ats;
    private final Crm crm;
    private final Iam iam;
    private final Marketing marketing;
    private final Lms lms;
    private final Ticketing ticketing;
    private final Documents documents;
    private final Screening screening;
    private final Messaging messaging;
    private final Accounting accounting;
    private final AsyncStackOne asyncSDK;

    public ConnectSessions connectSessions() {
        return this.connectSessions;
    }

    public Accounts accounts() {
        return this.accounts;
    }

    public RequestLogs requestLogs() {
        return this.requestLogs;
    }

    public Connectors connectors() {
        return this.connectors;
    }

    public Mcp mcp() {
        return this.mcp;
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public Actions actions() {
        return this.actions;
    }

    public Hris hris() {
        return this.hris;
    }

    public Ats ats() {
        return this.ats;
    }

    public Crm crm() {
        return this.crm;
    }

    public Iam iam() {
        return this.iam;
    }

    public Marketing marketing() {
        return this.marketing;
    }

    public Lms lms() {
        return this.lms;
    }

    public Ticketing ticketing() {
        return this.ticketing;
    }

    public Documents documents() {
        return this.documents;
    }

    public Screening screening() {
        return this.screening;
    }

    public Messaging messaging() {
        return this.messaging;
    }

    public Accounting accounting() {
        return this.accounting;
    }

    public static Builder builder() {
        return new Builder();
    }

    public StackOne(SDKConfiguration sdkConfiguration) {
        sdkConfiguration.initialize();
        this.connectSessions = new ConnectSessions(sdkConfiguration);
        this.accounts = new Accounts(sdkConfiguration);
        this.requestLogs = new RequestLogs(sdkConfiguration);
        this.connectors = new Connectors(sdkConfiguration);
        this.mcp = new Mcp(sdkConfiguration);
        this.proxy = new Proxy(sdkConfiguration);
        this.actions = new Actions(sdkConfiguration);
        this.hris = new Hris(sdkConfiguration);
        this.ats = new Ats(sdkConfiguration);
        this.crm = new Crm(sdkConfiguration);
        this.iam = new Iam(sdkConfiguration);
        this.marketing = new Marketing(sdkConfiguration);
        this.lms = new Lms(sdkConfiguration);
        this.ticketing = new Ticketing(sdkConfiguration);
        this.documents = new Documents(sdkConfiguration);
        this.screening = new Screening(sdkConfiguration);
        this.messaging = new Messaging(sdkConfiguration);
        this.accounting = new Accounting(sdkConfiguration);
        Hook.SdkInitData data = sdkConfiguration.hooks().sdkInit(new Hook.SdkInitData(sdkConfiguration.resolvedServerUrl(), sdkConfiguration.client()));
        sdkConfiguration.setServerUrl(data.baseUrl());
        sdkConfiguration.setClient(data.client());
        this.asyncSDK = new AsyncStackOne(this, sdkConfiguration);
    }

    public AsyncStackOne async() {
        return this.asyncSDK;
    }

    public static class Builder {
        private final SDKConfiguration sdkConfiguration = new SDKConfiguration();
        private String serverUrl;
        private String server;

        private Builder() {
        }

        public Builder client(HTTPClient client) {
            this.sdkConfiguration.setClient(client);
            return this;
        }

        public Builder security(Security security) {
            this.sdkConfiguration.setSecuritySource(SecuritySource.of(security));
            return this;
        }

        public Builder securitySource(SecuritySource securitySource) {
            Utils.checkNotNull(securitySource, "securitySource");
            this.sdkConfiguration.setSecuritySource(securitySource);
            return this;
        }

        public Builder serverURL(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public Builder serverURL(String serverUrl, Map<String, String> params) {
            this.serverUrl = Utils.templateUrl(serverUrl, params);
            return this;
        }

        public Builder serverIndex(int serverIdx) {
            this.sdkConfiguration.setServerIdx(serverIdx);
            this.serverUrl = SERVERS[serverIdx];
            return this;
        }

        public Builder retryConfig(RetryConfig retryConfig) {
            this.sdkConfiguration.setRetryConfig(Optional.of(retryConfig));
            return this;
        }

        public Builder enableHTTPDebugLogging(boolean enabled) {
            this.sdkConfiguration.client().enableDebugLogging(enabled);
            return this;
        }

        Builder _hooks(Hooks hooks) {
            this.sdkConfiguration.setHooks(hooks);
            return this;
        }

        Builder _hooks(Consumer<? super Hooks> consumer) {
            consumer.accept(this.sdkConfiguration.hooks());
            return this;
        }

        public StackOne build() {
            if (this.serverUrl == null || this.serverUrl.isBlank()) {
                this.serverUrl = SERVERS[0];
                this.sdkConfiguration.setServerIdx(0);
            }
            this.sdkConfiguration.setServerUrl(this.serverUrl);
            return new StackOne(this.sdkConfiguration);
        }
    }
}

