/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AccountingAccountValue {
    public static final AccountingAccountValue ASSET = new AccountingAccountValue("asset");
    public static final AccountingAccountValue LIABILITY = new AccountingAccountValue("liability");
    public static final AccountingAccountValue EQUITY = new AccountingAccountValue("equity");
    public static final AccountingAccountValue REVENUE = new AccountingAccountValue("revenue");
    public static final AccountingAccountValue EXPENSE = new AccountingAccountValue("expense");
    public static final AccountingAccountValue UNMAPPED_VALUE = new AccountingAccountValue("unmapped_value");
    private static final Map<String, AccountingAccountValue> values = AccountingAccountValue.createValuesMap();
    private static final Map<String, AccountingAccountValueEnum> enums = AccountingAccountValue.createEnumsMap();
    private final String value;

    private AccountingAccountValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static AccountingAccountValue of(String value) {
        Class<AccountingAccountValue> clazz = AccountingAccountValue.class;
        synchronized (AccountingAccountValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new AccountingAccountValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<AccountingAccountValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccountingAccountValue other = (AccountingAccountValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "AccountingAccountValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccountingAccountValue[] values() {
        Class<AccountingAccountValue> clazz = AccountingAccountValue.class;
        synchronized (AccountingAccountValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new AccountingAccountValue[0]);
        }
    }

    private static final Map<String, AccountingAccountValue> createValuesMap() {
        LinkedHashMap<String, AccountingAccountValue> map = new LinkedHashMap<String, AccountingAccountValue>();
        map.put("asset", ASSET);
        map.put("liability", LIABILITY);
        map.put("equity", EQUITY);
        map.put("revenue", REVENUE);
        map.put("expense", EXPENSE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AccountingAccountValueEnum> createEnumsMap() {
        HashMap<String, AccountingAccountValueEnum> map = new HashMap<String, AccountingAccountValueEnum>();
        map.put("asset", AccountingAccountValueEnum.ASSET);
        map.put("liability", AccountingAccountValueEnum.LIABILITY);
        map.put("equity", AccountingAccountValueEnum.EQUITY);
        map.put("revenue", AccountingAccountValueEnum.REVENUE);
        map.put("expense", AccountingAccountValueEnum.EXPENSE);
        map.put("unmapped_value", AccountingAccountValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum AccountingAccountValueEnum {
        ASSET("asset"),
        LIABILITY("liability"),
        EQUITY("equity"),
        REVENUE("revenue"),
        EXPENSE("expense"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private AccountingAccountValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

