/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.ActionSearchResultDto;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.List;
import java.util.Optional;

public class ActionSearchResponseDto {
    @JsonProperty(value="results")
    private List<ActionSearchResultDto> results;
    @JsonProperty(value="total_count")
    private double totalCount;
    @JsonProperty(value="query")
    private String query;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="connector_filter")
    private Optional<String> connectorFilter;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="project_filter")
    private Optional<String> projectFilter;

    @JsonCreator
    public ActionSearchResponseDto(@JsonProperty(value="results") List<ActionSearchResultDto> results, @JsonProperty(value="total_count") double totalCount, @JsonProperty(value="query") String query, @JsonProperty(value="connector_filter") Optional<String> connectorFilter, @JsonProperty(value="project_filter") Optional<String> projectFilter) {
        Utils.checkNotNull(results, "results");
        Utils.checkNotNull(totalCount, "totalCount");
        Utils.checkNotNull(query, "query");
        Utils.checkNotNull(connectorFilter, "connectorFilter");
        Utils.checkNotNull(projectFilter, "projectFilter");
        this.results = results;
        this.totalCount = totalCount;
        this.query = query;
        this.connectorFilter = connectorFilter;
        this.projectFilter = projectFilter;
    }

    public ActionSearchResponseDto(List<ActionSearchResultDto> results, double totalCount, String query) {
        this(results, totalCount, query, Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public List<ActionSearchResultDto> results() {
        return this.results;
    }

    @JsonIgnore
    public double totalCount() {
        return this.totalCount;
    }

    @JsonIgnore
    public String query() {
        return this.query;
    }

    @JsonIgnore
    public Optional<String> connectorFilter() {
        return this.connectorFilter;
    }

    @JsonIgnore
    public Optional<String> projectFilter() {
        return this.projectFilter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ActionSearchResponseDto withResults(List<ActionSearchResultDto> results) {
        Utils.checkNotNull(results, "results");
        this.results = results;
        return this;
    }

    public ActionSearchResponseDto withTotalCount(double totalCount) {
        Utils.checkNotNull(totalCount, "totalCount");
        this.totalCount = totalCount;
        return this;
    }

    public ActionSearchResponseDto withQuery(String query) {
        Utils.checkNotNull(query, "query");
        this.query = query;
        return this;
    }

    public ActionSearchResponseDto withConnectorFilter(String connectorFilter) {
        Utils.checkNotNull(connectorFilter, "connectorFilter");
        this.connectorFilter = Optional.ofNullable(connectorFilter);
        return this;
    }

    public ActionSearchResponseDto withConnectorFilter(Optional<String> connectorFilter) {
        Utils.checkNotNull(connectorFilter, "connectorFilter");
        this.connectorFilter = connectorFilter;
        return this;
    }

    public ActionSearchResponseDto withProjectFilter(String projectFilter) {
        Utils.checkNotNull(projectFilter, "projectFilter");
        this.projectFilter = Optional.ofNullable(projectFilter);
        return this;
    }

    public ActionSearchResponseDto withProjectFilter(Optional<String> projectFilter) {
        Utils.checkNotNull(projectFilter, "projectFilter");
        this.projectFilter = projectFilter;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionSearchResponseDto other = (ActionSearchResponseDto)o;
        return Utils.enhancedDeepEquals(this.results, other.results) && Utils.enhancedDeepEquals(this.totalCount, other.totalCount) && Utils.enhancedDeepEquals(this.query, other.query) && Utils.enhancedDeepEquals(this.connectorFilter, other.connectorFilter) && Utils.enhancedDeepEquals(this.projectFilter, other.projectFilter);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.results, this.totalCount, this.query, this.connectorFilter, this.projectFilter);
    }

    public String toString() {
        return Utils.toString(ActionSearchResponseDto.class, "results", this.results, "totalCount", this.totalCount, "query", this.query, "connectorFilter", this.connectorFilter, "projectFilter", this.projectFilter);
    }

    public static final class Builder {
        private List<ActionSearchResultDto> results;
        private Double totalCount;
        private String query;
        private Optional<String> connectorFilter = Optional.empty();
        private Optional<String> projectFilter = Optional.empty();

        private Builder() {
        }

        public Builder results(List<ActionSearchResultDto> results) {
            Utils.checkNotNull(results, "results");
            this.results = results;
            return this;
        }

        public Builder totalCount(double totalCount) {
            Utils.checkNotNull(totalCount, "totalCount");
            this.totalCount = totalCount;
            return this;
        }

        public Builder query(String query) {
            Utils.checkNotNull(query, "query");
            this.query = query;
            return this;
        }

        public Builder connectorFilter(String connectorFilter) {
            Utils.checkNotNull(connectorFilter, "connectorFilter");
            this.connectorFilter = Optional.ofNullable(connectorFilter);
            return this;
        }

        public Builder connectorFilter(Optional<String> connectorFilter) {
            Utils.checkNotNull(connectorFilter, "connectorFilter");
            this.connectorFilter = connectorFilter;
            return this;
        }

        public Builder projectFilter(String projectFilter) {
            Utils.checkNotNull(projectFilter, "projectFilter");
            this.projectFilter = Optional.ofNullable(projectFilter);
            return this;
        }

        public Builder projectFilter(Optional<String> projectFilter) {
            Utils.checkNotNull(projectFilter, "projectFilter");
            this.projectFilter = projectFilter;
            return this;
        }

        public ActionSearchResponseDto build() {
            return new ActionSearchResponseDto(this.results, this.totalCount, this.query, this.connectorFilter, this.projectFilter);
        }
    }
}

