/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ContentValue {
    public static final ContentValue VIDEO = new ContentValue("video");
    public static final ContentValue QUIZ = new ContentValue("quiz");
    public static final ContentValue DOCUMENT = new ContentValue("document");
    public static final ContentValue AUDIO = new ContentValue("audio");
    public static final ContentValue ARTICLE = new ContentValue("article");
    public static final ContentValue UNMAPPED_VALUE = new ContentValue("unmapped_value");
    private static final Map<String, ContentValue> values = ContentValue.createValuesMap();
    private static final Map<String, ContentValueEnum> enums = ContentValue.createEnumsMap();
    private final String value;

    private ContentValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static ContentValue of(String value) {
        Class<ContentValue> clazz = ContentValue.class;
        synchronized (ContentValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new ContentValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<ContentValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentValue other = (ContentValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "ContentValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentValue[] values() {
        Class<ContentValue> clazz = ContentValue.class;
        synchronized (ContentValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new ContentValue[0]);
        }
    }

    private static final Map<String, ContentValue> createValuesMap() {
        LinkedHashMap<String, ContentValue> map = new LinkedHashMap<String, ContentValue>();
        map.put("video", VIDEO);
        map.put("quiz", QUIZ);
        map.put("document", DOCUMENT);
        map.put("audio", AUDIO);
        map.put("article", ARTICLE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, ContentValueEnum> createEnumsMap() {
        HashMap<String, ContentValueEnum> map = new HashMap<String, ContentValueEnum>();
        map.put("video", ContentValueEnum.VIDEO);
        map.put("quiz", ContentValueEnum.QUIZ);
        map.put("document", ContentValueEnum.DOCUMENT);
        map.put("audio", ContentValueEnum.AUDIO);
        map.put("article", ContentValueEnum.ARTICLE);
        map.put("unmapped_value", ContentValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum ContentValueEnum {
        VIDEO("video"),
        QUIZ("quiz"),
        DOCUMENT("document"),
        AUDIO("audio"),
        ARTICLE("article"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private ContentValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

