/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CreateMessageValue {
    public static final CreateMessageValue EMAIL = new CreateMessageValue("email");
    public static final CreateMessageValue SMS = new CreateMessageValue("sms");
    public static final CreateMessageValue PUSH = new CreateMessageValue("push");
    public static final CreateMessageValue WEB_PUSH = new CreateMessageValue("web_push");
    public static final CreateMessageValue IOS_PUSH = new CreateMessageValue("ios_push");
    public static final CreateMessageValue ANDROID_PUSH = new CreateMessageValue("android_push");
    public static final CreateMessageValue APP_PUSH = new CreateMessageValue("app_push");
    public static final CreateMessageValue OMNI_CHANNEL = new CreateMessageValue("omni_channel");
    public static final CreateMessageValue CONTENT_BLOCK = new CreateMessageValue("content_block");
    public static final CreateMessageValue IN_APP = new CreateMessageValue("in_app");
    public static final CreateMessageValue UNKNOWN = new CreateMessageValue("unknown");
    public static final CreateMessageValue UNMAPPED_VALUE = new CreateMessageValue("unmapped_value");
    private static final Map<String, CreateMessageValue> values = CreateMessageValue.createValuesMap();
    private static final Map<String, CreateMessageValueEnum> enums = CreateMessageValue.createEnumsMap();
    private final String value;

    private CreateMessageValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static CreateMessageValue of(String value) {
        Class<CreateMessageValue> clazz = CreateMessageValue.class;
        synchronized (CreateMessageValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new CreateMessageValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<CreateMessageValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CreateMessageValue other = (CreateMessageValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "CreateMessageValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CreateMessageValue[] values() {
        Class<CreateMessageValue> clazz = CreateMessageValue.class;
        synchronized (CreateMessageValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new CreateMessageValue[0]);
        }
    }

    private static final Map<String, CreateMessageValue> createValuesMap() {
        LinkedHashMap<String, CreateMessageValue> map = new LinkedHashMap<String, CreateMessageValue>();
        map.put("email", EMAIL);
        map.put("sms", SMS);
        map.put("push", PUSH);
        map.put("web_push", WEB_PUSH);
        map.put("ios_push", IOS_PUSH);
        map.put("android_push", ANDROID_PUSH);
        map.put("app_push", APP_PUSH);
        map.put("omni_channel", OMNI_CHANNEL);
        map.put("content_block", CONTENT_BLOCK);
        map.put("in_app", IN_APP);
        map.put("unknown", UNKNOWN);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, CreateMessageValueEnum> createEnumsMap() {
        HashMap<String, CreateMessageValueEnum> map = new HashMap<String, CreateMessageValueEnum>();
        map.put("email", CreateMessageValueEnum.EMAIL);
        map.put("sms", CreateMessageValueEnum.SMS);
        map.put("push", CreateMessageValueEnum.PUSH);
        map.put("web_push", CreateMessageValueEnum.WEB_PUSH);
        map.put("ios_push", CreateMessageValueEnum.IOS_PUSH);
        map.put("android_push", CreateMessageValueEnum.ANDROID_PUSH);
        map.put("app_push", CreateMessageValueEnum.APP_PUSH);
        map.put("omni_channel", CreateMessageValueEnum.OMNI_CHANNEL);
        map.put("content_block", CreateMessageValueEnum.CONTENT_BLOCK);
        map.put("in_app", CreateMessageValueEnum.IN_APP);
        map.put("unknown", CreateMessageValueEnum.UNKNOWN);
        map.put("unmapped_value", CreateMessageValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum CreateMessageValueEnum {
        EMAIL("email"),
        SMS("sms"),
        PUSH("push"),
        WEB_PUSH("web_push"),
        IOS_PUSH("ios_push"),
        ANDROID_PUSH("android_push"),
        APP_PUSH("app_push"),
        OMNI_CHANNEL("omni_channel"),
        CONTENT_BLOCK("content_block"),
        IN_APP("in_app"),
        UNKNOWN("unknown"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private CreateMessageValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

