/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class EmploymentTypeValue {
    public static final EmploymentTypeValue CONTRACTOR = new EmploymentTypeValue("contractor");
    public static final EmploymentTypeValue INTERN = new EmploymentTypeValue("intern");
    public static final EmploymentTypeValue PERMANENT = new EmploymentTypeValue("permanent");
    public static final EmploymentTypeValue APPRENTICE = new EmploymentTypeValue("apprentice");
    public static final EmploymentTypeValue FREELANCE = new EmploymentTypeValue("freelance");
    public static final EmploymentTypeValue TERMINATED = new EmploymentTypeValue("terminated");
    public static final EmploymentTypeValue TEMPORARY = new EmploymentTypeValue("temporary");
    public static final EmploymentTypeValue SEASONAL = new EmploymentTypeValue("seasonal");
    public static final EmploymentTypeValue VOLUNTEER = new EmploymentTypeValue("volunteer");
    public static final EmploymentTypeValue PROBATION = new EmploymentTypeValue("probation");
    public static final EmploymentTypeValue INTERNAL = new EmploymentTypeValue("internal");
    public static final EmploymentTypeValue EXTERNAL = new EmploymentTypeValue("external");
    public static final EmploymentTypeValue EXPATRIATE = new EmploymentTypeValue("expatriate");
    public static final EmploymentTypeValue EMPLOYER_OF_RECORD = new EmploymentTypeValue("employer_of_record");
    public static final EmploymentTypeValue CASUAL = new EmploymentTypeValue("casual");
    public static final EmploymentTypeValue PROGRAMME = new EmploymentTypeValue("Programme");
    public static final EmploymentTypeValue UNMAPPED_VALUE = new EmploymentTypeValue("unmapped_value");
    private static final Map<String, EmploymentTypeValue> values = EmploymentTypeValue.createValuesMap();
    private static final Map<String, EmploymentTypeValueEnum> enums = EmploymentTypeValue.createEnumsMap();
    private final String value;

    private EmploymentTypeValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static EmploymentTypeValue of(String value) {
        Class<EmploymentTypeValue> clazz = EmploymentTypeValue.class;
        synchronized (EmploymentTypeValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new EmploymentTypeValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<EmploymentTypeValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmploymentTypeValue other = (EmploymentTypeValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "EmploymentTypeValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmploymentTypeValue[] values() {
        Class<EmploymentTypeValue> clazz = EmploymentTypeValue.class;
        synchronized (EmploymentTypeValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new EmploymentTypeValue[0]);
        }
    }

    private static final Map<String, EmploymentTypeValue> createValuesMap() {
        LinkedHashMap<String, EmploymentTypeValue> map = new LinkedHashMap<String, EmploymentTypeValue>();
        map.put("contractor", CONTRACTOR);
        map.put("intern", INTERN);
        map.put("permanent", PERMANENT);
        map.put("apprentice", APPRENTICE);
        map.put("freelance", FREELANCE);
        map.put("terminated", TERMINATED);
        map.put("temporary", TEMPORARY);
        map.put("seasonal", SEASONAL);
        map.put("volunteer", VOLUNTEER);
        map.put("probation", PROBATION);
        map.put("internal", INTERNAL);
        map.put("external", EXTERNAL);
        map.put("expatriate", EXPATRIATE);
        map.put("employer_of_record", EMPLOYER_OF_RECORD);
        map.put("casual", CASUAL);
        map.put("Programme", PROGRAMME);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, EmploymentTypeValueEnum> createEnumsMap() {
        HashMap<String, EmploymentTypeValueEnum> map = new HashMap<String, EmploymentTypeValueEnum>();
        map.put("contractor", EmploymentTypeValueEnum.CONTRACTOR);
        map.put("intern", EmploymentTypeValueEnum.INTERN);
        map.put("permanent", EmploymentTypeValueEnum.PERMANENT);
        map.put("apprentice", EmploymentTypeValueEnum.APPRENTICE);
        map.put("freelance", EmploymentTypeValueEnum.FREELANCE);
        map.put("terminated", EmploymentTypeValueEnum.TERMINATED);
        map.put("temporary", EmploymentTypeValueEnum.TEMPORARY);
        map.put("seasonal", EmploymentTypeValueEnum.SEASONAL);
        map.put("volunteer", EmploymentTypeValueEnum.VOLUNTEER);
        map.put("probation", EmploymentTypeValueEnum.PROBATION);
        map.put("internal", EmploymentTypeValueEnum.INTERNAL);
        map.put("external", EmploymentTypeValueEnum.EXTERNAL);
        map.put("expatriate", EmploymentTypeValueEnum.EXPATRIATE);
        map.put("employer_of_record", EmploymentTypeValueEnum.EMPLOYER_OF_RECORD);
        map.put("casual", EmploymentTypeValueEnum.CASUAL);
        map.put("Programme", EmploymentTypeValueEnum.PROGRAMME);
        map.put("unmapped_value", EmploymentTypeValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum EmploymentTypeValueEnum {
        CONTRACTOR("contractor"),
        INTERN("intern"),
        PERMANENT("permanent"),
        APPRENTICE("apprentice"),
        FREELANCE("freelance"),
        TERMINATED("terminated"),
        TEMPORARY("temporary"),
        SEASONAL("seasonal"),
        VOLUNTEER("volunteer"),
        PROBATION("probation"),
        INTERNAL("internal"),
        EXTERNAL("external"),
        EXPATRIATE("expatriate"),
        EMPLOYER_OF_RECORD("employer_of_record"),
        CASUAL("casual"),
        PROGRAMME("Programme"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private EmploymentTypeValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

