/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class WorkEligibilityValue {
    public static final WorkEligibilityValue VISA = new WorkEligibilityValue("visa");
    public static final WorkEligibilityValue PASSPORT = new WorkEligibilityValue("passport");
    public static final WorkEligibilityValue DRIVER_LICENSE = new WorkEligibilityValue("driver_license");
    public static final WorkEligibilityValue BIRTH_CERTIFICATE = new WorkEligibilityValue("birth_certificate");
    public static final WorkEligibilityValue OTHER = new WorkEligibilityValue("other");
    public static final WorkEligibilityValue UNMAPPED_VALUE = new WorkEligibilityValue("unmapped_value");
    private static final Map<String, WorkEligibilityValue> values = WorkEligibilityValue.createValuesMap();
    private static final Map<String, WorkEligibilityValueEnum> enums = WorkEligibilityValue.createEnumsMap();
    private final String value;

    private WorkEligibilityValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static WorkEligibilityValue of(String value) {
        Class<WorkEligibilityValue> clazz = WorkEligibilityValue.class;
        synchronized (WorkEligibilityValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new WorkEligibilityValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<WorkEligibilityValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkEligibilityValue other = (WorkEligibilityValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "WorkEligibilityValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkEligibilityValue[] values() {
        Class<WorkEligibilityValue> clazz = WorkEligibilityValue.class;
        synchronized (WorkEligibilityValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new WorkEligibilityValue[0]);
        }
    }

    private static final Map<String, WorkEligibilityValue> createValuesMap() {
        LinkedHashMap<String, WorkEligibilityValue> map = new LinkedHashMap<String, WorkEligibilityValue>();
        map.put("visa", VISA);
        map.put("passport", PASSPORT);
        map.put("driver_license", DRIVER_LICENSE);
        map.put("birth_certificate", BIRTH_CERTIFICATE);
        map.put("other", OTHER);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, WorkEligibilityValueEnum> createEnumsMap() {
        HashMap<String, WorkEligibilityValueEnum> map = new HashMap<String, WorkEligibilityValueEnum>();
        map.put("visa", WorkEligibilityValueEnum.VISA);
        map.put("passport", WorkEligibilityValueEnum.PASSPORT);
        map.put("driver_license", WorkEligibilityValueEnum.DRIVER_LICENSE);
        map.put("birth_certificate", WorkEligibilityValueEnum.BIRTH_CERTIFICATE);
        map.put("other", WorkEligibilityValueEnum.OTHER);
        map.put("unmapped_value", WorkEligibilityValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum WorkEligibilityValueEnum {
        VISA("visa"),
        PASSPORT("passport"),
        DRIVER_LICENSE("driver_license"),
        BIRTH_CERTIFICATE("birth_certificate"),
        OTHER("other"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private WorkEligibilityValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

