/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsUpdateBackgroundCheckResultRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class AtsUpdateBackgroundCheckResultRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private AtsUpdateBackgroundCheckResultRequestDto atsUpdateBackgroundCheckResultRequestDto;

    @JsonCreator
    public AtsUpdateBackgroundCheckResultRequest(String xAccountId, String id, Optional<String> prefer, AtsUpdateBackgroundCheckResultRequestDto atsUpdateBackgroundCheckResultRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(atsUpdateBackgroundCheckResultRequestDto, "atsUpdateBackgroundCheckResultRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.prefer = prefer;
        this.atsUpdateBackgroundCheckResultRequestDto = atsUpdateBackgroundCheckResultRequestDto;
    }

    public AtsUpdateBackgroundCheckResultRequest(String xAccountId, String id, AtsUpdateBackgroundCheckResultRequestDto atsUpdateBackgroundCheckResultRequestDto) {
        this(xAccountId, id, Optional.empty(), atsUpdateBackgroundCheckResultRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public AtsUpdateBackgroundCheckResultRequestDto atsUpdateBackgroundCheckResultRequestDto() {
        return this.atsUpdateBackgroundCheckResultRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsUpdateBackgroundCheckResultRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsUpdateBackgroundCheckResultRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AtsUpdateBackgroundCheckResultRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public AtsUpdateBackgroundCheckResultRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public AtsUpdateBackgroundCheckResultRequest withAtsUpdateBackgroundCheckResultRequestDto(AtsUpdateBackgroundCheckResultRequestDto atsUpdateBackgroundCheckResultRequestDto) {
        Utils.checkNotNull(atsUpdateBackgroundCheckResultRequestDto, "atsUpdateBackgroundCheckResultRequestDto");
        this.atsUpdateBackgroundCheckResultRequestDto = atsUpdateBackgroundCheckResultRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsUpdateBackgroundCheckResultRequest other = (AtsUpdateBackgroundCheckResultRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.atsUpdateBackgroundCheckResultRequestDto, other.atsUpdateBackgroundCheckResultRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.id, this.prefer, this.atsUpdateBackgroundCheckResultRequestDto);
    }

    public String toString() {
        return Utils.toString(AtsUpdateBackgroundCheckResultRequest.class, "xAccountId", this.xAccountId, "id", this.id, "prefer", this.prefer, "atsUpdateBackgroundCheckResultRequestDto", this.atsUpdateBackgroundCheckResultRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private Optional<String> prefer = Optional.empty();
        private AtsUpdateBackgroundCheckResultRequestDto atsUpdateBackgroundCheckResultRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder atsUpdateBackgroundCheckResultRequestDto(AtsUpdateBackgroundCheckResultRequestDto atsUpdateBackgroundCheckResultRequestDto) {
            Utils.checkNotNull(atsUpdateBackgroundCheckResultRequestDto, "atsUpdateBackgroundCheckResultRequestDto");
            this.atsUpdateBackgroundCheckResultRequestDto = atsUpdateBackgroundCheckResultRequestDto;
            return this;
        }

        public AtsUpdateBackgroundCheckResultRequest build() {
            return new AtsUpdateBackgroundCheckResultRequest(this.xAccountId, this.id, this.prefer, this.atsUpdateBackgroundCheckResultRequestDto);
        }
    }
}

