/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AtsUpdateCandidateRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class AtsUpdateCandidateRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private AtsUpdateCandidateRequestDto atsUpdateCandidateRequestDto;

    @JsonCreator
    public AtsUpdateCandidateRequest(String xAccountId, String id, Optional<String> prefer, AtsUpdateCandidateRequestDto atsUpdateCandidateRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(atsUpdateCandidateRequestDto, "atsUpdateCandidateRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.prefer = prefer;
        this.atsUpdateCandidateRequestDto = atsUpdateCandidateRequestDto;
    }

    public AtsUpdateCandidateRequest(String xAccountId, String id, AtsUpdateCandidateRequestDto atsUpdateCandidateRequestDto) {
        this(xAccountId, id, Optional.empty(), atsUpdateCandidateRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public AtsUpdateCandidateRequestDto atsUpdateCandidateRequestDto() {
        return this.atsUpdateCandidateRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsUpdateCandidateRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsUpdateCandidateRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AtsUpdateCandidateRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public AtsUpdateCandidateRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public AtsUpdateCandidateRequest withAtsUpdateCandidateRequestDto(AtsUpdateCandidateRequestDto atsUpdateCandidateRequestDto) {
        Utils.checkNotNull(atsUpdateCandidateRequestDto, "atsUpdateCandidateRequestDto");
        this.atsUpdateCandidateRequestDto = atsUpdateCandidateRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsUpdateCandidateRequest other = (AtsUpdateCandidateRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.atsUpdateCandidateRequestDto, other.atsUpdateCandidateRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.id, this.prefer, this.atsUpdateCandidateRequestDto);
    }

    public String toString() {
        return Utils.toString(AtsUpdateCandidateRequest.class, "xAccountId", this.xAccountId, "id", this.id, "prefer", this.prefer, "atsUpdateCandidateRequestDto", this.atsUpdateCandidateRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private Optional<String> prefer = Optional.empty();
        private AtsUpdateCandidateRequestDto atsUpdateCandidateRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder atsUpdateCandidateRequestDto(AtsUpdateCandidateRequestDto atsUpdateCandidateRequestDto) {
            Utils.checkNotNull(atsUpdateCandidateRequestDto, "atsUpdateCandidateRequestDto");
            this.atsUpdateCandidateRequestDto = atsUpdateCandidateRequestDto;
            return this;
        }

        public AtsUpdateCandidateRequest build() {
            return new AtsUpdateCandidateRequest(this.xAccountId, this.id, this.prefer, this.atsUpdateCandidateRequestDto);
        }
    }
}

