/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HrisCreateEmployeeRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class HrisCreateEmployeeRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private HrisCreateEmployeeRequestDto hrisCreateEmployeeRequestDto;

    @JsonCreator
    public HrisCreateEmployeeRequest(String xAccountId, Optional<String> prefer, HrisCreateEmployeeRequestDto hrisCreateEmployeeRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(hrisCreateEmployeeRequestDto, "hrisCreateEmployeeRequestDto");
        this.xAccountId = xAccountId;
        this.prefer = prefer;
        this.hrisCreateEmployeeRequestDto = hrisCreateEmployeeRequestDto;
    }

    public HrisCreateEmployeeRequest(String xAccountId, HrisCreateEmployeeRequestDto hrisCreateEmployeeRequestDto) {
        this(xAccountId, Optional.empty(), hrisCreateEmployeeRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public HrisCreateEmployeeRequestDto hrisCreateEmployeeRequestDto() {
        return this.hrisCreateEmployeeRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisCreateEmployeeRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public HrisCreateEmployeeRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public HrisCreateEmployeeRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public HrisCreateEmployeeRequest withHrisCreateEmployeeRequestDto(HrisCreateEmployeeRequestDto hrisCreateEmployeeRequestDto) {
        Utils.checkNotNull(hrisCreateEmployeeRequestDto, "hrisCreateEmployeeRequestDto");
        this.hrisCreateEmployeeRequestDto = hrisCreateEmployeeRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisCreateEmployeeRequest other = (HrisCreateEmployeeRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.hrisCreateEmployeeRequestDto, other.hrisCreateEmployeeRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.prefer, this.hrisCreateEmployeeRequestDto);
    }

    public String toString() {
        return Utils.toString(HrisCreateEmployeeRequest.class, "xAccountId", this.xAccountId, "prefer", this.prefer, "hrisCreateEmployeeRequestDto", this.hrisCreateEmployeeRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private Optional<String> prefer = Optional.empty();
        private HrisCreateEmployeeRequestDto hrisCreateEmployeeRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder hrisCreateEmployeeRequestDto(HrisCreateEmployeeRequestDto hrisCreateEmployeeRequestDto) {
            Utils.checkNotNull(hrisCreateEmployeeRequestDto, "hrisCreateEmployeeRequestDto");
            this.hrisCreateEmployeeRequestDto = hrisCreateEmployeeRequestDto;
            return this;
        }

        public HrisCreateEmployeeRequest build() {
            return new HrisCreateEmployeeRequest(this.xAccountId, this.prefer, this.hrisCreateEmployeeRequestDto);
        }
    }
}

