/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HrisUpdateEmployeeRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class HrisUpdateEmployeeRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private HrisUpdateEmployeeRequestDto hrisUpdateEmployeeRequestDto;

    @JsonCreator
    public HrisUpdateEmployeeRequest(String xAccountId, String id, Optional<String> prefer, HrisUpdateEmployeeRequestDto hrisUpdateEmployeeRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(hrisUpdateEmployeeRequestDto, "hrisUpdateEmployeeRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.prefer = prefer;
        this.hrisUpdateEmployeeRequestDto = hrisUpdateEmployeeRequestDto;
    }

    public HrisUpdateEmployeeRequest(String xAccountId, String id, HrisUpdateEmployeeRequestDto hrisUpdateEmployeeRequestDto) {
        this(xAccountId, id, Optional.empty(), hrisUpdateEmployeeRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public HrisUpdateEmployeeRequestDto hrisUpdateEmployeeRequestDto() {
        return this.hrisUpdateEmployeeRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisUpdateEmployeeRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public HrisUpdateEmployeeRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public HrisUpdateEmployeeRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public HrisUpdateEmployeeRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public HrisUpdateEmployeeRequest withHrisUpdateEmployeeRequestDto(HrisUpdateEmployeeRequestDto hrisUpdateEmployeeRequestDto) {
        Utils.checkNotNull(hrisUpdateEmployeeRequestDto, "hrisUpdateEmployeeRequestDto");
        this.hrisUpdateEmployeeRequestDto = hrisUpdateEmployeeRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisUpdateEmployeeRequest other = (HrisUpdateEmployeeRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.hrisUpdateEmployeeRequestDto, other.hrisUpdateEmployeeRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.id, this.prefer, this.hrisUpdateEmployeeRequestDto);
    }

    public String toString() {
        return Utils.toString(HrisUpdateEmployeeRequest.class, "xAccountId", this.xAccountId, "id", this.id, "prefer", this.prefer, "hrisUpdateEmployeeRequestDto", this.hrisUpdateEmployeeRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private Optional<String> prefer = Optional.empty();
        private HrisUpdateEmployeeRequestDto hrisUpdateEmployeeRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder hrisUpdateEmployeeRequestDto(HrisUpdateEmployeeRequestDto hrisUpdateEmployeeRequestDto) {
            Utils.checkNotNull(hrisUpdateEmployeeRequestDto, "hrisUpdateEmployeeRequestDto");
            this.hrisUpdateEmployeeRequestDto = hrisUpdateEmployeeRequestDto;
            return this;
        }

        public HrisUpdateEmployeeRequest build() {
            return new HrisUpdateEmployeeRequest(this.xAccountId, this.id, this.prefer, this.hrisUpdateEmployeeRequestDto);
        }
    }
}

