/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.MessageSourceValue;
import com.stackone.stackone_client_java.models.components.MessageValue;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class MessageMessageType {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="value")
    private JsonNullable<? extends MessageValue> value;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="source_value")
    private JsonNullable<? extends MessageSourceValue> sourceValue;

    @JsonCreator
    public MessageMessageType(@JsonProperty(value="value") JsonNullable<? extends MessageValue> value, @JsonProperty(value="source_value") JsonNullable<? extends MessageSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }

    public MessageMessageType() {
        this((JsonNullable<? extends MessageValue>)JsonNullable.undefined(), (JsonNullable<? extends MessageSourceValue>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<MessageValue> value() {
        return this.value;
    }

    @JsonIgnore
    public JsonNullable<MessageSourceValue> sourceValue() {
        return this.sourceValue;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public MessageMessageType withValue(MessageValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of((Object)value);
        return this;
    }

    public MessageMessageType withValue(JsonNullable<? extends MessageValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public MessageMessageType withSourceValue(MessageSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of((Object)sourceValue);
        return this;
    }

    public MessageMessageType withSourceValue(JsonNullable<? extends MessageSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageMessageType other = (MessageMessageType)o;
        return Objects.deepEquals(this.value, other.value) && Objects.deepEquals(this.sourceValue, other.sourceValue);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.sourceValue);
    }

    public String toString() {
        return Utils.toString(MessageMessageType.class, "value", this.value, "sourceValue", this.sourceValue);
    }

    public static final class Builder {
        private JsonNullable<? extends MessageValue> value = JsonNullable.undefined();
        private JsonNullable<? extends MessageSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
        }

        public Builder value(MessageValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of((Object)value);
            return this;
        }

        public Builder value(JsonNullable<? extends MessageValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(MessageSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of((Object)sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends MessageSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public MessageMessageType build() {
            return new MessageMessageType(this.value, this.sourceValue);
        }
    }
}

