/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.TimeOffPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class HrisListEmployeeTimeOffRequestsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends TimeOffPaginated> timeOffPaginated;
    private Map<String, List<String>> headers;
    private Callable<Optional<HrisListEmployeeTimeOffRequestsResponse>> next = () -> Optional.empty();

    @JsonCreator
    public HrisListEmployeeTimeOffRequestsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends TimeOffPaginated> timeOffPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(timeOffPaginated, "timeOffPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.timeOffPaginated = timeOffPaginated;
        this.headers = headers;
    }

    public HrisListEmployeeTimeOffRequestsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<TimeOffPaginated> timeOffPaginated() {
        return this.timeOffPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Optional<HrisListEmployeeTimeOffRequestsResponse> next() throws Exception {
        return this.next.call();
    }

    private HrisListEmployeeTimeOffRequestsResponse withNext(Callable<Optional<HrisListEmployeeTimeOffRequestsResponse>> next) {
        this.next = next;
        return this;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public HrisListEmployeeTimeOffRequestsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisListEmployeeTimeOffRequestsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisListEmployeeTimeOffRequestsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisListEmployeeTimeOffRequestsResponse withTimeOffPaginated(TimeOffPaginated timeOffPaginated) {
        Utils.checkNotNull(timeOffPaginated, "timeOffPaginated");
        this.timeOffPaginated = Optional.ofNullable(timeOffPaginated);
        return this;
    }

    public HrisListEmployeeTimeOffRequestsResponse withTimeOffPaginated(Optional<? extends TimeOffPaginated> timeOffPaginated) {
        Utils.checkNotNull(timeOffPaginated, "timeOffPaginated");
        this.timeOffPaginated = timeOffPaginated;
        return this;
    }

    public HrisListEmployeeTimeOffRequestsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisListEmployeeTimeOffRequestsResponse other = (HrisListEmployeeTimeOffRequestsResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.timeOffPaginated, other.timeOffPaginated) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.timeOffPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisListEmployeeTimeOffRequestsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "timeOffPaginated", this.timeOffPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private Callable<Optional<HrisListEmployeeTimeOffRequestsResponse>> next;
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends TimeOffPaginated> timeOffPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder timeOffPaginated(TimeOffPaginated timeOffPaginated) {
            Utils.checkNotNull(timeOffPaginated, "timeOffPaginated");
            this.timeOffPaginated = Optional.ofNullable(timeOffPaginated);
            return this;
        }

        public Builder timeOffPaginated(Optional<? extends TimeOffPaginated> timeOffPaginated) {
            Utils.checkNotNull(timeOffPaginated, "timeOffPaginated");
            this.timeOffPaginated = timeOffPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        @Deprecated
        public Builder next(Callable<Optional<HrisListEmployeeTimeOffRequestsResponse>> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        public HrisListEmployeeTimeOffRequestsResponse build() {
            return new HrisListEmployeeTimeOffRequestsResponse(this.contentType, this.statusCode, this.rawResponse, this.timeOffPaginated, this.headers).withNext(this.next);
        }
    }
}

