/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;

public class ConnectSessionTokenAuthLink {

    @JsonProperty("id")
    private double id;

    @JsonProperty("organization_id")
    private double organizationId;

    @JsonProperty("project_id")
    private String projectId;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("categories")
    private JsonNullable<? extends List<ConnectSessionTokenAuthLinkCategories>> categories;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("provider")
    private JsonNullable<String> provider;

    @JsonProperty("origin_owner_id")
    private String originOwnerId;

    @JsonProperty("origin_owner_name")
    private String originOwnerName;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("origin_username")
    private JsonNullable<String> originUsername;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("account_id")
    private JsonNullable<String> accountId;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("label")
    private JsonNullable<String> label;

    @JsonProperty("created_at")
    private OffsetDateTime createdAt;

    /**
     * Arbitrary set of key and values defined during the session token creation. This can be used to tag an account (eg. based on their pricing plan)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("metadata")
    private JsonNullable<? extends ConnectSessionTokenAuthLinkMetadata> metadata;

    /**
     * External trigger token to be used to trigger actions on the account
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("external_trigger_token")
    private JsonNullable<String> externalTriggerToken;

    /**
     * The connect session account type
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("type")
    private JsonNullable<? extends ConnectSessionTokenAuthLinkType> type;

    @JsonProperty("token")
    private String token;

    @JsonProperty("auth_link_url")
    private String authLinkUrl;

    @JsonCreator
    public ConnectSessionTokenAuthLink(
            @JsonProperty("id") double id,
            @JsonProperty("organization_id") double organizationId,
            @JsonProperty("project_id") String projectId,
            @JsonProperty("categories") JsonNullable<? extends List<ConnectSessionTokenAuthLinkCategories>> categories,
            @JsonProperty("provider") JsonNullable<String> provider,
            @JsonProperty("origin_owner_id") String originOwnerId,
            @JsonProperty("origin_owner_name") String originOwnerName,
            @JsonProperty("origin_username") JsonNullable<String> originUsername,
            @JsonProperty("account_id") JsonNullable<String> accountId,
            @JsonProperty("label") JsonNullable<String> label,
            @JsonProperty("created_at") OffsetDateTime createdAt,
            @JsonProperty("metadata") JsonNullable<? extends ConnectSessionTokenAuthLinkMetadata> metadata,
            @JsonProperty("external_trigger_token") JsonNullable<String> externalTriggerToken,
            @JsonProperty("type") JsonNullable<? extends ConnectSessionTokenAuthLinkType> type,
            @JsonProperty("token") String token,
            @JsonProperty("auth_link_url") String authLinkUrl) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(organizationId, "organizationId");
        Utils.checkNotNull(projectId, "projectId");
        Utils.checkNotNull(categories, "categories");
        Utils.checkNotNull(provider, "provider");
        Utils.checkNotNull(originOwnerId, "originOwnerId");
        Utils.checkNotNull(originOwnerName, "originOwnerName");
        Utils.checkNotNull(originUsername, "originUsername");
        Utils.checkNotNull(accountId, "accountId");
        Utils.checkNotNull(label, "label");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(metadata, "metadata");
        Utils.checkNotNull(externalTriggerToken, "externalTriggerToken");
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(token, "token");
        Utils.checkNotNull(authLinkUrl, "authLinkUrl");
        this.id = id;
        this.organizationId = organizationId;
        this.projectId = projectId;
        this.categories = categories;
        this.provider = provider;
        this.originOwnerId = originOwnerId;
        this.originOwnerName = originOwnerName;
        this.originUsername = originUsername;
        this.accountId = accountId;
        this.label = label;
        this.createdAt = createdAt;
        this.metadata = metadata;
        this.externalTriggerToken = externalTriggerToken;
        this.type = type;
        this.token = token;
        this.authLinkUrl = authLinkUrl;
    }
    
    public ConnectSessionTokenAuthLink(
            double id,
            double organizationId,
            String projectId,
            String originOwnerId,
            String originOwnerName,
            OffsetDateTime createdAt,
            String token,
            String authLinkUrl) {
        this(id, organizationId, projectId, JsonNullable.undefined(), JsonNullable.undefined(), originOwnerId, originOwnerName, JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), createdAt, JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), token, authLinkUrl);
    }

    @JsonIgnore
    public double id() {
        return id;
    }

    @JsonIgnore
    public double organizationId() {
        return organizationId;
    }

    @JsonIgnore
    public String projectId() {
        return projectId;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<ConnectSessionTokenAuthLinkCategories>> categories() {
        return (JsonNullable<List<ConnectSessionTokenAuthLinkCategories>>) categories;
    }

    @JsonIgnore
    public JsonNullable<String> provider() {
        return provider;
    }

    @JsonIgnore
    public String originOwnerId() {
        return originOwnerId;
    }

    @JsonIgnore
    public String originOwnerName() {
        return originOwnerName;
    }

    @JsonIgnore
    public JsonNullable<String> originUsername() {
        return originUsername;
    }

    @JsonIgnore
    public JsonNullable<String> accountId() {
        return accountId;
    }

    @JsonIgnore
    public JsonNullable<String> label() {
        return label;
    }

    @JsonIgnore
    public OffsetDateTime createdAt() {
        return createdAt;
    }

    /**
     * Arbitrary set of key and values defined during the session token creation. This can be used to tag an account (eg. based on their pricing plan)
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ConnectSessionTokenAuthLinkMetadata> metadata() {
        return (JsonNullable<ConnectSessionTokenAuthLinkMetadata>) metadata;
    }

    /**
     * External trigger token to be used to trigger actions on the account
     */
    @JsonIgnore
    public JsonNullable<String> externalTriggerToken() {
        return externalTriggerToken;
    }

    /**
     * The connect session account type
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ConnectSessionTokenAuthLinkType> type() {
        return (JsonNullable<ConnectSessionTokenAuthLinkType>) type;
    }

    @JsonIgnore
    public String token() {
        return token;
    }

    @JsonIgnore
    public String authLinkUrl() {
        return authLinkUrl;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    public ConnectSessionTokenAuthLink withId(double id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public ConnectSessionTokenAuthLink withOrganizationId(double organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public ConnectSessionTokenAuthLink withProjectId(String projectId) {
        Utils.checkNotNull(projectId, "projectId");
        this.projectId = projectId;
        return this;
    }

    public ConnectSessionTokenAuthLink withCategories(List<ConnectSessionTokenAuthLinkCategories> categories) {
        Utils.checkNotNull(categories, "categories");
        this.categories = JsonNullable.of(categories);
        return this;
    }

    public ConnectSessionTokenAuthLink withCategories(JsonNullable<? extends List<ConnectSessionTokenAuthLinkCategories>> categories) {
        Utils.checkNotNull(categories, "categories");
        this.categories = categories;
        return this;
    }

    public ConnectSessionTokenAuthLink withProvider(String provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = JsonNullable.of(provider);
        return this;
    }

    public ConnectSessionTokenAuthLink withProvider(JsonNullable<String> provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = provider;
        return this;
    }

    public ConnectSessionTokenAuthLink withOriginOwnerId(String originOwnerId) {
        Utils.checkNotNull(originOwnerId, "originOwnerId");
        this.originOwnerId = originOwnerId;
        return this;
    }

    public ConnectSessionTokenAuthLink withOriginOwnerName(String originOwnerName) {
        Utils.checkNotNull(originOwnerName, "originOwnerName");
        this.originOwnerName = originOwnerName;
        return this;
    }

    public ConnectSessionTokenAuthLink withOriginUsername(String originUsername) {
        Utils.checkNotNull(originUsername, "originUsername");
        this.originUsername = JsonNullable.of(originUsername);
        return this;
    }

    public ConnectSessionTokenAuthLink withOriginUsername(JsonNullable<String> originUsername) {
        Utils.checkNotNull(originUsername, "originUsername");
        this.originUsername = originUsername;
        return this;
    }

    public ConnectSessionTokenAuthLink withAccountId(String accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = JsonNullable.of(accountId);
        return this;
    }

    public ConnectSessionTokenAuthLink withAccountId(JsonNullable<String> accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = accountId;
        return this;
    }

    public ConnectSessionTokenAuthLink withLabel(String label) {
        Utils.checkNotNull(label, "label");
        this.label = JsonNullable.of(label);
        return this;
    }

    public ConnectSessionTokenAuthLink withLabel(JsonNullable<String> label) {
        Utils.checkNotNull(label, "label");
        this.label = label;
        return this;
    }

    public ConnectSessionTokenAuthLink withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * Arbitrary set of key and values defined during the session token creation. This can be used to tag an account (eg. based on their pricing plan)
     */
    public ConnectSessionTokenAuthLink withMetadata(ConnectSessionTokenAuthLinkMetadata metadata) {
        Utils.checkNotNull(metadata, "metadata");
        this.metadata = JsonNullable.of(metadata);
        return this;
    }

    /**
     * Arbitrary set of key and values defined during the session token creation. This can be used to tag an account (eg. based on their pricing plan)
     */
    public ConnectSessionTokenAuthLink withMetadata(JsonNullable<? extends ConnectSessionTokenAuthLinkMetadata> metadata) {
        Utils.checkNotNull(metadata, "metadata");
        this.metadata = metadata;
        return this;
    }

    /**
     * External trigger token to be used to trigger actions on the account
     */
    public ConnectSessionTokenAuthLink withExternalTriggerToken(String externalTriggerToken) {
        Utils.checkNotNull(externalTriggerToken, "externalTriggerToken");
        this.externalTriggerToken = JsonNullable.of(externalTriggerToken);
        return this;
    }

    /**
     * External trigger token to be used to trigger actions on the account
     */
    public ConnectSessionTokenAuthLink withExternalTriggerToken(JsonNullable<String> externalTriggerToken) {
        Utils.checkNotNull(externalTriggerToken, "externalTriggerToken");
        this.externalTriggerToken = externalTriggerToken;
        return this;
    }

    /**
     * The connect session account type
     */
    public ConnectSessionTokenAuthLink withType(ConnectSessionTokenAuthLinkType type) {
        Utils.checkNotNull(type, "type");
        this.type = JsonNullable.of(type);
        return this;
    }

    /**
     * The connect session account type
     */
    public ConnectSessionTokenAuthLink withType(JsonNullable<? extends ConnectSessionTokenAuthLinkType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    public ConnectSessionTokenAuthLink withToken(String token) {
        Utils.checkNotNull(token, "token");
        this.token = token;
        return this;
    }

    public ConnectSessionTokenAuthLink withAuthLinkUrl(String authLinkUrl) {
        Utils.checkNotNull(authLinkUrl, "authLinkUrl");
        this.authLinkUrl = authLinkUrl;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ConnectSessionTokenAuthLink other = (ConnectSessionTokenAuthLink) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.organizationId, other.organizationId) &&
            Utils.enhancedDeepEquals(this.projectId, other.projectId) &&
            Utils.enhancedDeepEquals(this.categories, other.categories) &&
            Utils.enhancedDeepEquals(this.provider, other.provider) &&
            Utils.enhancedDeepEquals(this.originOwnerId, other.originOwnerId) &&
            Utils.enhancedDeepEquals(this.originOwnerName, other.originOwnerName) &&
            Utils.enhancedDeepEquals(this.originUsername, other.originUsername) &&
            Utils.enhancedDeepEquals(this.accountId, other.accountId) &&
            Utils.enhancedDeepEquals(this.label, other.label) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt) &&
            Utils.enhancedDeepEquals(this.metadata, other.metadata) &&
            Utils.enhancedDeepEquals(this.externalTriggerToken, other.externalTriggerToken) &&
            Utils.enhancedDeepEquals(this.type, other.type) &&
            Utils.enhancedDeepEquals(this.token, other.token) &&
            Utils.enhancedDeepEquals(this.authLinkUrl, other.authLinkUrl);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id,
            organizationId,
            projectId,
            categories,
            provider,
            originOwnerId,
            originOwnerName,
            originUsername,
            accountId,
            label,
            createdAt,
            metadata,
            externalTriggerToken,
            type,
            token,
            authLinkUrl);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ConnectSessionTokenAuthLink.class,
                "id", id,
                "organizationId", organizationId,
                "projectId", projectId,
                "categories", categories,
                "provider", provider,
                "originOwnerId", originOwnerId,
                "originOwnerName", originOwnerName,
                "originUsername", originUsername,
                "accountId", accountId,
                "label", label,
                "createdAt", createdAt,
                "metadata", metadata,
                "externalTriggerToken", externalTriggerToken,
                "type", type,
                "token", token,
                "authLinkUrl", authLinkUrl);
    }
    
    public final static class Builder {
 
        private Double id;
 
        private Double organizationId;
 
        private String projectId;
 
        private JsonNullable<? extends List<ConnectSessionTokenAuthLinkCategories>> categories = JsonNullable.undefined();
 
        private JsonNullable<String> provider = JsonNullable.undefined();
 
        private String originOwnerId;
 
        private String originOwnerName;
 
        private JsonNullable<String> originUsername = JsonNullable.undefined();
 
        private JsonNullable<String> accountId = JsonNullable.undefined();
 
        private JsonNullable<String> label = JsonNullable.undefined();
 
        private OffsetDateTime createdAt;
 
        private JsonNullable<? extends ConnectSessionTokenAuthLinkMetadata> metadata = JsonNullable.undefined();
 
        private JsonNullable<String> externalTriggerToken = JsonNullable.undefined();
 
        private JsonNullable<? extends ConnectSessionTokenAuthLinkType> type = JsonNullable.undefined();
 
        private String token;
 
        private String authLinkUrl;
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder id(double id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder organizationId(double organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = organizationId;
            return this;
        }

        public Builder projectId(String projectId) {
            Utils.checkNotNull(projectId, "projectId");
            this.projectId = projectId;
            return this;
        }

        public Builder categories(List<ConnectSessionTokenAuthLinkCategories> categories) {
            Utils.checkNotNull(categories, "categories");
            this.categories = JsonNullable.of(categories);
            return this;
        }

        public Builder categories(JsonNullable<? extends List<ConnectSessionTokenAuthLinkCategories>> categories) {
            Utils.checkNotNull(categories, "categories");
            this.categories = categories;
            return this;
        }

        public Builder provider(String provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = JsonNullable.of(provider);
            return this;
        }

        public Builder provider(JsonNullable<String> provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = provider;
            return this;
        }

        public Builder originOwnerId(String originOwnerId) {
            Utils.checkNotNull(originOwnerId, "originOwnerId");
            this.originOwnerId = originOwnerId;
            return this;
        }

        public Builder originOwnerName(String originOwnerName) {
            Utils.checkNotNull(originOwnerName, "originOwnerName");
            this.originOwnerName = originOwnerName;
            return this;
        }

        public Builder originUsername(String originUsername) {
            Utils.checkNotNull(originUsername, "originUsername");
            this.originUsername = JsonNullable.of(originUsername);
            return this;
        }

        public Builder originUsername(JsonNullable<String> originUsername) {
            Utils.checkNotNull(originUsername, "originUsername");
            this.originUsername = originUsername;
            return this;
        }

        public Builder accountId(String accountId) {
            Utils.checkNotNull(accountId, "accountId");
            this.accountId = JsonNullable.of(accountId);
            return this;
        }

        public Builder accountId(JsonNullable<String> accountId) {
            Utils.checkNotNull(accountId, "accountId");
            this.accountId = accountId;
            return this;
        }

        public Builder label(String label) {
            Utils.checkNotNull(label, "label");
            this.label = JsonNullable.of(label);
            return this;
        }

        public Builder label(JsonNullable<String> label) {
            Utils.checkNotNull(label, "label");
            this.label = label;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        /**
         * Arbitrary set of key and values defined during the session token creation. This can be used to tag an account (eg. based on their pricing plan)
         */
        public Builder metadata(ConnectSessionTokenAuthLinkMetadata metadata) {
            Utils.checkNotNull(metadata, "metadata");
            this.metadata = JsonNullable.of(metadata);
            return this;
        }

        /**
         * Arbitrary set of key and values defined during the session token creation. This can be used to tag an account (eg. based on their pricing plan)
         */
        public Builder metadata(JsonNullable<? extends ConnectSessionTokenAuthLinkMetadata> metadata) {
            Utils.checkNotNull(metadata, "metadata");
            this.metadata = metadata;
            return this;
        }

        /**
         * External trigger token to be used to trigger actions on the account
         */
        public Builder externalTriggerToken(String externalTriggerToken) {
            Utils.checkNotNull(externalTriggerToken, "externalTriggerToken");
            this.externalTriggerToken = JsonNullable.of(externalTriggerToken);
            return this;
        }

        /**
         * External trigger token to be used to trigger actions on the account
         */
        public Builder externalTriggerToken(JsonNullable<String> externalTriggerToken) {
            Utils.checkNotNull(externalTriggerToken, "externalTriggerToken");
            this.externalTriggerToken = externalTriggerToken;
            return this;
        }

        /**
         * The connect session account type
         */
        public Builder type(ConnectSessionTokenAuthLinkType type) {
            Utils.checkNotNull(type, "type");
            this.type = JsonNullable.of(type);
            return this;
        }

        /**
         * The connect session account type
         */
        public Builder type(JsonNullable<? extends ConnectSessionTokenAuthLinkType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }

        public Builder token(String token) {
            Utils.checkNotNull(token, "token");
            this.token = token;
            return this;
        }

        public Builder authLinkUrl(String authLinkUrl) {
            Utils.checkNotNull(authLinkUrl, "authLinkUrl");
            this.authLinkUrl = authLinkUrl;
            return this;
        }
        
        public ConnectSessionTokenAuthLink build() {
            return new ConnectSessionTokenAuthLink(
                id,
                organizationId,
                projectId,
                categories,
                provider,
                originOwnerId,
                originOwnerName,
                originUsername,
                accountId,
                label,
                createdAt,
                metadata,
                externalTriggerToken,
                type,
                token,
                authLinkUrl);
        }
    }
}
