/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * EmploymentDepartment
 * 
 * <p>The employee department
 */
public class EmploymentDepartment {

    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("unified_custom_fields")
    private JsonNullable<? extends Map<String, Object>> unifiedCustomFields;

    /**
     * The name of the group
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * The list of parent group ids of the given group
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("parent_ids")
    private JsonNullable<? extends List<String>> parentIds;

    /**
     * Provider's list of parent group remote ids of the given group
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_parent_ids")
    private JsonNullable<? extends List<String>> remoteParentIds;

    /**
     * The list of group owner ids of the given group
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("owner_ids")
    private JsonNullable<? extends List<String>> ownerIds;

    /**
     * The list of remote group owner ids of the given group
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_owner_ids")
    private JsonNullable<? extends List<String>> remoteOwnerIds;

    /**
     * The id of the company that the group belongs to
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("company_id")
    private JsonNullable<String> companyId;

    /**
     * Provider's id of the company that the group belongs to
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_company_id")
    private JsonNullable<String> remoteCompanyId;

    /**
     * The type of the group
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("type")
    private JsonNullable<? extends EmploymentDepartmentType> type;

    @JsonCreator
    public EmploymentDepartment(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("unified_custom_fields") JsonNullable<? extends Map<String, Object>> unifiedCustomFields,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("parent_ids") JsonNullable<? extends List<String>> parentIds,
            @JsonProperty("remote_parent_ids") JsonNullable<? extends List<String>> remoteParentIds,
            @JsonProperty("owner_ids") JsonNullable<? extends List<String>> ownerIds,
            @JsonProperty("remote_owner_ids") JsonNullable<? extends List<String>> remoteOwnerIds,
            @JsonProperty("company_id") JsonNullable<String> companyId,
            @JsonProperty("remote_company_id") JsonNullable<String> remoteCompanyId,
            @JsonProperty("type") JsonNullable<? extends EmploymentDepartmentType> type) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(parentIds, "parentIds");
        Utils.checkNotNull(remoteParentIds, "remoteParentIds");
        Utils.checkNotNull(ownerIds, "ownerIds");
        Utils.checkNotNull(remoteOwnerIds, "remoteOwnerIds");
        Utils.checkNotNull(companyId, "companyId");
        Utils.checkNotNull(remoteCompanyId, "remoteCompanyId");
        Utils.checkNotNull(type, "type");
        this.id = id;
        this.remoteId = remoteId;
        this.unifiedCustomFields = unifiedCustomFields;
        this.name = name;
        this.parentIds = parentIds;
        this.remoteParentIds = remoteParentIds;
        this.ownerIds = ownerIds;
        this.remoteOwnerIds = remoteOwnerIds;
        this.companyId = companyId;
        this.remoteCompanyId = remoteCompanyId;
        this.type = type;
    }
    
    public EmploymentDepartment() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> unifiedCustomFields() {
        return (JsonNullable<Map<String, Object>>) unifiedCustomFields;
    }

    /**
     * The name of the group
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * The list of parent group ids of the given group
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> parentIds() {
        return (JsonNullable<List<String>>) parentIds;
    }

    /**
     * Provider's list of parent group remote ids of the given group
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> remoteParentIds() {
        return (JsonNullable<List<String>>) remoteParentIds;
    }

    /**
     * The list of group owner ids of the given group
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> ownerIds() {
        return (JsonNullable<List<String>>) ownerIds;
    }

    /**
     * The list of remote group owner ids of the given group
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> remoteOwnerIds() {
        return (JsonNullable<List<String>>) remoteOwnerIds;
    }

    /**
     * The id of the company that the group belongs to
     */
    @JsonIgnore
    public JsonNullable<String> companyId() {
        return companyId;
    }

    /**
     * Provider's id of the company that the group belongs to
     */
    @JsonIgnore
    public JsonNullable<String> remoteCompanyId() {
        return remoteCompanyId;
    }

    /**
     * The type of the group
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<EmploymentDepartmentType> type() {
        return (JsonNullable<EmploymentDepartmentType>) type;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Unique identifier
     */
    public EmploymentDepartment withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public EmploymentDepartment withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public EmploymentDepartment withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public EmploymentDepartment withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public EmploymentDepartment withUnifiedCustomFields(Map<String, Object> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public EmploymentDepartment withUnifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = unifiedCustomFields;
        return this;
    }

    /**
     * The name of the group
     */
    public EmploymentDepartment withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * The name of the group
     */
    public EmploymentDepartment withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * The list of parent group ids of the given group
     */
    public EmploymentDepartment withParentIds(List<String> parentIds) {
        Utils.checkNotNull(parentIds, "parentIds");
        this.parentIds = JsonNullable.of(parentIds);
        return this;
    }

    /**
     * The list of parent group ids of the given group
     */
    public EmploymentDepartment withParentIds(JsonNullable<? extends List<String>> parentIds) {
        Utils.checkNotNull(parentIds, "parentIds");
        this.parentIds = parentIds;
        return this;
    }

    /**
     * Provider's list of parent group remote ids of the given group
     */
    public EmploymentDepartment withRemoteParentIds(List<String> remoteParentIds) {
        Utils.checkNotNull(remoteParentIds, "remoteParentIds");
        this.remoteParentIds = JsonNullable.of(remoteParentIds);
        return this;
    }

    /**
     * Provider's list of parent group remote ids of the given group
     */
    public EmploymentDepartment withRemoteParentIds(JsonNullable<? extends List<String>> remoteParentIds) {
        Utils.checkNotNull(remoteParentIds, "remoteParentIds");
        this.remoteParentIds = remoteParentIds;
        return this;
    }

    /**
     * The list of group owner ids of the given group
     */
    public EmploymentDepartment withOwnerIds(List<String> ownerIds) {
        Utils.checkNotNull(ownerIds, "ownerIds");
        this.ownerIds = JsonNullable.of(ownerIds);
        return this;
    }

    /**
     * The list of group owner ids of the given group
     */
    public EmploymentDepartment withOwnerIds(JsonNullable<? extends List<String>> ownerIds) {
        Utils.checkNotNull(ownerIds, "ownerIds");
        this.ownerIds = ownerIds;
        return this;
    }

    /**
     * The list of remote group owner ids of the given group
     */
    public EmploymentDepartment withRemoteOwnerIds(List<String> remoteOwnerIds) {
        Utils.checkNotNull(remoteOwnerIds, "remoteOwnerIds");
        this.remoteOwnerIds = JsonNullable.of(remoteOwnerIds);
        return this;
    }

    /**
     * The list of remote group owner ids of the given group
     */
    public EmploymentDepartment withRemoteOwnerIds(JsonNullable<? extends List<String>> remoteOwnerIds) {
        Utils.checkNotNull(remoteOwnerIds, "remoteOwnerIds");
        this.remoteOwnerIds = remoteOwnerIds;
        return this;
    }

    /**
     * The id of the company that the group belongs to
     */
    public EmploymentDepartment withCompanyId(String companyId) {
        Utils.checkNotNull(companyId, "companyId");
        this.companyId = JsonNullable.of(companyId);
        return this;
    }

    /**
     * The id of the company that the group belongs to
     */
    public EmploymentDepartment withCompanyId(JsonNullable<String> companyId) {
        Utils.checkNotNull(companyId, "companyId");
        this.companyId = companyId;
        return this;
    }

    /**
     * Provider's id of the company that the group belongs to
     */
    public EmploymentDepartment withRemoteCompanyId(String remoteCompanyId) {
        Utils.checkNotNull(remoteCompanyId, "remoteCompanyId");
        this.remoteCompanyId = JsonNullable.of(remoteCompanyId);
        return this;
    }

    /**
     * Provider's id of the company that the group belongs to
     */
    public EmploymentDepartment withRemoteCompanyId(JsonNullable<String> remoteCompanyId) {
        Utils.checkNotNull(remoteCompanyId, "remoteCompanyId");
        this.remoteCompanyId = remoteCompanyId;
        return this;
    }

    /**
     * The type of the group
     */
    public EmploymentDepartment withType(EmploymentDepartmentType type) {
        Utils.checkNotNull(type, "type");
        this.type = JsonNullable.of(type);
        return this;
    }

    /**
     * The type of the group
     */
    public EmploymentDepartment withType(JsonNullable<? extends EmploymentDepartmentType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EmploymentDepartment other = (EmploymentDepartment) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.unifiedCustomFields, other.unifiedCustomFields) &&
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.parentIds, other.parentIds) &&
            Utils.enhancedDeepEquals(this.remoteParentIds, other.remoteParentIds) &&
            Utils.enhancedDeepEquals(this.ownerIds, other.ownerIds) &&
            Utils.enhancedDeepEquals(this.remoteOwnerIds, other.remoteOwnerIds) &&
            Utils.enhancedDeepEquals(this.companyId, other.companyId) &&
            Utils.enhancedDeepEquals(this.remoteCompanyId, other.remoteCompanyId) &&
            Utils.enhancedDeepEquals(this.type, other.type);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id,
            remoteId,
            unifiedCustomFields,
            name,
            parentIds,
            remoteParentIds,
            ownerIds,
            remoteOwnerIds,
            companyId,
            remoteCompanyId,
            type);
    }
    
    @Override
    public String toString() {
        return Utils.toString(EmploymentDepartment.class,
                "id", id,
                "remoteId", remoteId,
                "unifiedCustomFields", unifiedCustomFields,
                "name", name,
                "parentIds", parentIds,
                "remoteParentIds", remoteParentIds,
                "ownerIds", ownerIds,
                "remoteOwnerIds", remoteOwnerIds,
                "companyId", companyId,
                "remoteCompanyId", remoteCompanyId,
                "type", type);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> remoteId = JsonNullable.undefined();
 
        private JsonNullable<? extends Map<String, Object>> unifiedCustomFields = JsonNullable.undefined();
 
        private JsonNullable<String> name = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> parentIds = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> remoteParentIds = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> ownerIds = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> remoteOwnerIds = JsonNullable.undefined();
 
        private JsonNullable<String> companyId = JsonNullable.undefined();
 
        private JsonNullable<String> remoteCompanyId = JsonNullable.undefined();
 
        private JsonNullable<? extends EmploymentDepartmentType> type = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(Map<String, Object> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = unifiedCustomFields;
            return this;
        }

        /**
         * The name of the group
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * The name of the group
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        /**
         * The list of parent group ids of the given group
         */
        public Builder parentIds(List<String> parentIds) {
            Utils.checkNotNull(parentIds, "parentIds");
            this.parentIds = JsonNullable.of(parentIds);
            return this;
        }

        /**
         * The list of parent group ids of the given group
         */
        public Builder parentIds(JsonNullable<? extends List<String>> parentIds) {
            Utils.checkNotNull(parentIds, "parentIds");
            this.parentIds = parentIds;
            return this;
        }

        /**
         * Provider's list of parent group remote ids of the given group
         */
        public Builder remoteParentIds(List<String> remoteParentIds) {
            Utils.checkNotNull(remoteParentIds, "remoteParentIds");
            this.remoteParentIds = JsonNullable.of(remoteParentIds);
            return this;
        }

        /**
         * Provider's list of parent group remote ids of the given group
         */
        public Builder remoteParentIds(JsonNullable<? extends List<String>> remoteParentIds) {
            Utils.checkNotNull(remoteParentIds, "remoteParentIds");
            this.remoteParentIds = remoteParentIds;
            return this;
        }

        /**
         * The list of group owner ids of the given group
         */
        public Builder ownerIds(List<String> ownerIds) {
            Utils.checkNotNull(ownerIds, "ownerIds");
            this.ownerIds = JsonNullable.of(ownerIds);
            return this;
        }

        /**
         * The list of group owner ids of the given group
         */
        public Builder ownerIds(JsonNullable<? extends List<String>> ownerIds) {
            Utils.checkNotNull(ownerIds, "ownerIds");
            this.ownerIds = ownerIds;
            return this;
        }

        /**
         * The list of remote group owner ids of the given group
         */
        public Builder remoteOwnerIds(List<String> remoteOwnerIds) {
            Utils.checkNotNull(remoteOwnerIds, "remoteOwnerIds");
            this.remoteOwnerIds = JsonNullable.of(remoteOwnerIds);
            return this;
        }

        /**
         * The list of remote group owner ids of the given group
         */
        public Builder remoteOwnerIds(JsonNullable<? extends List<String>> remoteOwnerIds) {
            Utils.checkNotNull(remoteOwnerIds, "remoteOwnerIds");
            this.remoteOwnerIds = remoteOwnerIds;
            return this;
        }

        /**
         * The id of the company that the group belongs to
         */
        public Builder companyId(String companyId) {
            Utils.checkNotNull(companyId, "companyId");
            this.companyId = JsonNullable.of(companyId);
            return this;
        }

        /**
         * The id of the company that the group belongs to
         */
        public Builder companyId(JsonNullable<String> companyId) {
            Utils.checkNotNull(companyId, "companyId");
            this.companyId = companyId;
            return this;
        }

        /**
         * Provider's id of the company that the group belongs to
         */
        public Builder remoteCompanyId(String remoteCompanyId) {
            Utils.checkNotNull(remoteCompanyId, "remoteCompanyId");
            this.remoteCompanyId = JsonNullable.of(remoteCompanyId);
            return this;
        }

        /**
         * Provider's id of the company that the group belongs to
         */
        public Builder remoteCompanyId(JsonNullable<String> remoteCompanyId) {
            Utils.checkNotNull(remoteCompanyId, "remoteCompanyId");
            this.remoteCompanyId = remoteCompanyId;
            return this;
        }

        /**
         * The type of the group
         */
        public Builder type(EmploymentDepartmentType type) {
            Utils.checkNotNull(type, "type");
            this.type = JsonNullable.of(type);
            return this;
        }

        /**
         * The type of the group
         */
        public Builder type(JsonNullable<? extends EmploymentDepartmentType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }
        
        public EmploymentDepartment build() {
            return new EmploymentDepartment(
                id,
                remoteId,
                unifiedCustomFields,
                name,
                parentIds,
                remoteParentIds,
                ownerIds,
                remoteOwnerIds,
                companyId,
                remoteCompanyId,
                type);
        }
    }
}
