/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

public class IamResourceType {

    /**
     * The type of the resource, e.g. user, group, permission, etc.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends IamResourceValue> value;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends IamResourceSourceValue> sourceValue;

    @JsonCreator
    public IamResourceType(
            @JsonProperty("value") JsonNullable<? extends IamResourceValue> value,
            @JsonProperty("source_value") JsonNullable<? extends IamResourceSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public IamResourceType() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The type of the resource, e.g. user, group, permission, etc.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<IamResourceValue> value() {
        return (JsonNullable<IamResourceValue>) value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<IamResourceSourceValue> sourceValue() {
        return (JsonNullable<IamResourceSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The type of the resource, e.g. user, group, permission, etc.
     */
    public IamResourceType withValue(IamResourceValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The type of the resource, e.g. user, group, permission, etc.
     */
    public IamResourceType withValue(JsonNullable<? extends IamResourceValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public IamResourceType withSourceValue(IamResourceSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public IamResourceType withSourceValue(JsonNullable<? extends IamResourceSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IamResourceType other = (IamResourceType) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(IamResourceType.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends IamResourceValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends IamResourceSourceValue> sourceValue = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The type of the resource, e.g. user, group, permission, etc.
         */
        public Builder value(IamResourceValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The type of the resource, e.g. user, group, permission, etc.
         */
        public Builder value(JsonNullable<? extends IamResourceValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(IamResourceSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends IamResourceSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public IamResourceType build() {
            return new IamResourceType(
                value,
                sourceValue);
        }
    }
}
