/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AssessmentResultsResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsGetAssessmentsResultResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends AssessmentResultsResult> assessmentResultsResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsGetAssessmentsResultResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends AssessmentResultsResult> assessmentResultsResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(assessmentResultsResult, "assessmentResultsResult");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.assessmentResultsResult = assessmentResultsResult;
        this.headers = headers;
    }

    public AtsGetAssessmentsResultResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<AssessmentResultsResult> assessmentResultsResult() {
        return this.assessmentResultsResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AtsGetAssessmentsResultResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsGetAssessmentsResultResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsGetAssessmentsResultResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsGetAssessmentsResultResponse withAssessmentResultsResult(AssessmentResultsResult assessmentResultsResult) {
        Utils.checkNotNull(assessmentResultsResult, "assessmentResultsResult");
        this.assessmentResultsResult = Optional.ofNullable(assessmentResultsResult);
        return this;
    }

    public AtsGetAssessmentsResultResponse withAssessmentResultsResult(Optional<? extends AssessmentResultsResult> assessmentResultsResult) {
        Utils.checkNotNull(assessmentResultsResult, "assessmentResultsResult");
        this.assessmentResultsResult = assessmentResultsResult;
        return this;
    }

    public AtsGetAssessmentsResultResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsGetAssessmentsResultResponse other = (AtsGetAssessmentsResultResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.assessmentResultsResult, other.assessmentResultsResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.assessmentResultsResult, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsGetAssessmentsResultResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "assessmentResultsResult", this.assessmentResultsResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends AssessmentResultsResult> assessmentResultsResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder assessmentResultsResult(AssessmentResultsResult assessmentResultsResult) {
            Utils.checkNotNull(assessmentResultsResult, "assessmentResultsResult");
            this.assessmentResultsResult = Optional.ofNullable(assessmentResultsResult);
            return this;
        }

        public Builder assessmentResultsResult(Optional<? extends AssessmentResultsResult> assessmentResultsResult) {
            Utils.checkNotNull(assessmentResultsResult, "assessmentResultsResult");
            this.assessmentResultsResult = assessmentResultsResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsGetAssessmentsResultResponse build() {
            return new AtsGetAssessmentsResultResponse(this.contentType, this.statusCode, this.rawResponse, this.assessmentResultsResult, this.headers);
        }
    }
}

