/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.CandidatesPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsListCandidatesResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends CandidatesPaginated> candidatesPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsListCandidatesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends CandidatesPaginated> candidatesPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(candidatesPaginated, "candidatesPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.candidatesPaginated = candidatesPaginated;
        this.headers = headers;
    }

    public AtsListCandidatesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<CandidatesPaginated> candidatesPaginated() {
        return this.candidatesPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AtsListCandidatesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsListCandidatesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsListCandidatesResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsListCandidatesResponse withCandidatesPaginated(CandidatesPaginated candidatesPaginated) {
        Utils.checkNotNull(candidatesPaginated, "candidatesPaginated");
        this.candidatesPaginated = Optional.ofNullable(candidatesPaginated);
        return this;
    }

    public AtsListCandidatesResponse withCandidatesPaginated(Optional<? extends CandidatesPaginated> candidatesPaginated) {
        Utils.checkNotNull(candidatesPaginated, "candidatesPaginated");
        this.candidatesPaginated = candidatesPaginated;
        return this;
    }

    public AtsListCandidatesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsListCandidatesResponse other = (AtsListCandidatesResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.candidatesPaginated, other.candidatesPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.candidatesPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsListCandidatesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "candidatesPaginated", this.candidatesPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends CandidatesPaginated> candidatesPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder candidatesPaginated(CandidatesPaginated candidatesPaginated) {
            Utils.checkNotNull(candidatesPaginated, "candidatesPaginated");
            this.candidatesPaginated = Optional.ofNullable(candidatesPaginated);
            return this;
        }

        public Builder candidatesPaginated(Optional<? extends CandidatesPaginated> candidatesPaginated) {
            Utils.checkNotNull(candidatesPaginated, "candidatesPaginated");
            this.candidatesPaginated = candidatesPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsListCandidatesResponse build() {
            return new AtsListCandidatesResponse(this.contentType, this.statusCode, this.rawResponse, this.candidatesPaginated, this.headers);
        }
    }
}

