/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.PositionsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisListPositionsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends PositionsPaginated> positionsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisListPositionsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends PositionsPaginated> positionsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(positionsPaginated, "positionsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.positionsPaginated = positionsPaginated;
        this.headers = headers;
    }

    public HrisListPositionsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<PositionsPaginated> positionsPaginated() {
        return this.positionsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public HrisListPositionsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisListPositionsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisListPositionsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisListPositionsResponse withPositionsPaginated(PositionsPaginated positionsPaginated) {
        Utils.checkNotNull(positionsPaginated, "positionsPaginated");
        this.positionsPaginated = Optional.ofNullable(positionsPaginated);
        return this;
    }

    public HrisListPositionsResponse withPositionsPaginated(Optional<? extends PositionsPaginated> positionsPaginated) {
        Utils.checkNotNull(positionsPaginated, "positionsPaginated");
        this.positionsPaginated = positionsPaginated;
        return this;
    }

    public HrisListPositionsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisListPositionsResponse other = (HrisListPositionsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.positionsPaginated, other.positionsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.positionsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisListPositionsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "positionsPaginated", this.positionsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends PositionsPaginated> positionsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder positionsPaginated(PositionsPaginated positionsPaginated) {
            Utils.checkNotNull(positionsPaginated, "positionsPaginated");
            this.positionsPaginated = Optional.ofNullable(positionsPaginated);
            return this;
        }

        public Builder positionsPaginated(Optional<? extends PositionsPaginated> positionsPaginated) {
            Utils.checkNotNull(positionsPaginated, "positionsPaginated");
            this.positionsPaginated = positionsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisListPositionsResponse build() {
            return new HrisListPositionsResponse(this.contentType, this.statusCode, this.rawResponse, this.positionsPaginated, this.headers);
        }
    }
}

