/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.utils;

import java.io.CharArrayWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Objects;

public final class Utf8UrlEncoder {
    private static final BitSet DO_NOT_ENCODE_CHARS = Utf8UrlEncoder.createDoNotEncodeChars();
    private static final int CASE_DIFF = 32;
    private final BitSet safeChars;
    public static final Utf8UrlEncoder ALLOW_RESERVED = new Utf8UrlEncoder(":/?#[]@!$&'()*+,;=");
    public static final Utf8UrlEncoder DEFAULT = new Utf8UrlEncoder("");

    public static Utf8UrlEncoder allowReserved(boolean allowReserved) {
        return allowReserved ? ALLOW_RESERVED : DEFAULT;
    }

    private Utf8UrlEncoder(String safeCharacters) {
        Objects.requireNonNull(safeCharacters, "safeCharacters");
        int max = -1;
        for (int i = 0; i < safeCharacters.length(); ++i) {
            char ch = safeCharacters.charAt(i);
            max = Math.max(ch, max);
        }
        BitSet safeChars = new BitSet(max + 1);
        for (int i = 0; i < safeCharacters.length(); ++i) {
            char ch = safeCharacters.charAt(i);
            safeChars.set(ch);
        }
        this.safeChars = safeChars;
    }

    public String encode(String s) {
        return this.encode(s, StandardCharsets.UTF_8);
    }

    private String encode(String s, Charset charset) {
        boolean changed = false;
        StringBuilder out = new StringBuilder(s.length());
        CharArrayWriter writer = new CharArrayWriter();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (DO_NOT_ENCODE_CHARS.get(c) || this.safeChars.get(c)) {
                out.append(c);
                ++i;
                continue;
            }
            do {
                char d;
                writer.write(c);
                if (c < '\ud800' || c > '\udbff' || i + 1 >= s.length() || (d = s.charAt(i + 1)) < '\udc00' || d > '\udfff') continue;
                writer.write(d);
                ++i;
            } while (++i < s.length() && !DO_NOT_ENCODE_CHARS.get(c = s.charAt(i)));
            writer.flush();
            String str = new String(writer.toCharArray());
            byte[] ba = str.getBytes(charset);
            for (int j = 0; j < ba.length; ++j) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            writer.reset();
            changed = true;
        }
        return changed ? out.toString() : s;
    }

    private static BitSet createDoNotEncodeChars() {
        int i;
        BitSet b = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            b.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            b.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            b.set(i);
        }
        b.set(45);
        b.set(95);
        b.set(46);
        b.set(42);
        return b;
    }
}

