/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class JobValue {
    public static final JobValue PUBLISHED = new JobValue("published");
    public static final JobValue DRAFT = new JobValue("draft");
    public static final JobValue PENDING = new JobValue("pending");
    public static final JobValue INTERNAL = new JobValue("internal");
    public static final JobValue ARCHIVED = new JobValue("archived");
    public static final JobValue CLOSED = new JobValue("closed");
    public static final JobValue OPEN = new JobValue("open");
    public static final JobValue DELETED = new JobValue("deleted");
    public static final JobValue ON_HOLD = new JobValue("on_hold");
    public static final JobValue UNMAPPED_VALUE = new JobValue("unmapped_value");
    private static final Map<String, JobValue> values = JobValue.createValuesMap();
    private static final Map<String, JobValueEnum> enums = JobValue.createEnumsMap();
    private final String value;

    private JobValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobValue of(String value) {
        Class<JobValue> clazz = JobValue.class;
        synchronized (JobValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new JobValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<JobValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JobValue other = (JobValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "JobValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobValue[] values() {
        Class<JobValue> clazz = JobValue.class;
        synchronized (JobValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new JobValue[0]);
        }
    }

    private static final Map<String, JobValue> createValuesMap() {
        LinkedHashMap<String, JobValue> map = new LinkedHashMap<String, JobValue>();
        map.put("published", PUBLISHED);
        map.put("draft", DRAFT);
        map.put("pending", PENDING);
        map.put("internal", INTERNAL);
        map.put("archived", ARCHIVED);
        map.put("closed", CLOSED);
        map.put("open", OPEN);
        map.put("deleted", DELETED);
        map.put("on_hold", ON_HOLD);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, JobValueEnum> createEnumsMap() {
        HashMap<String, JobValueEnum> map = new HashMap<String, JobValueEnum>();
        map.put("published", JobValueEnum.PUBLISHED);
        map.put("draft", JobValueEnum.DRAFT);
        map.put("pending", JobValueEnum.PENDING);
        map.put("internal", JobValueEnum.INTERNAL);
        map.put("archived", JobValueEnum.ARCHIVED);
        map.put("closed", JobValueEnum.CLOSED);
        map.put("open", JobValueEnum.OPEN);
        map.put("deleted", JobValueEnum.DELETED);
        map.put("on_hold", JobValueEnum.ON_HOLD);
        map.put("unmapped_value", JobValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum JobValueEnum {
        PUBLISHED("published"),
        DRAFT("draft"),
        PENDING("pending"),
        INTERNAL("internal"),
        ARCHIVED("archived"),
        CLOSED("closed"),
        OPEN("open"),
        DELETED("deleted"),
        ON_HOLD("on_hold"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private JobValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<JobValue> {
        protected _Deserializer() {
            super(JobValue.class);
        }

        public JobValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return JobValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<JobValue> {
        protected _Serializer() {
            super(JobValue.class);
        }

        public void serialize(JobValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

