/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.stackone.stackone_client_java.utils.FormMetadata;
import com.stackone.stackone_client_java.utils.JSON;
import com.stackone.stackone_client_java.utils.Multipart;
import com.stackone.stackone_client_java.utils.MultipartFormMetadata;
import com.stackone.stackone_client_java.utils.NameValue;
import com.stackone.stackone_client_java.utils.QueryEncoding;
import com.stackone.stackone_client_java.utils.RequestMetadata;
import com.stackone.stackone_client_java.utils.SerializedBody;
import com.stackone.stackone_client_java.utils.Types;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.openapitools.jackson.nullable.JsonNullable;

public final class RequestBody {
    private static final Map<String, String> SERIALIZATION_METHOD_TO_CONTENT_TYPE = Map.of("json", "application/json", "form", "application/x-www-form-urlencoded", "multipart", "multipart/form-data", "raw", "application/octet-stream", "string", "text/plain");

    private RequestBody() {
    }

    public static SerializedBody serialize(Object request, String requestField, String serializationMethod, boolean nullable) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException, UnsupportedOperationException, IOException {
        if (request == null) {
            return null;
        }
        if (!nullable && request instanceof Optional && ((Optional)request).isEmpty()) {
            request = JsonNullable.undefined();
        }
        if (Types.getType(request.getClass()) != Types.OBJECT) {
            return RequestBody.serializeContentType(requestField, SERIALIZATION_METHOD_TO_CONTENT_TYPE.get(serializationMethod), request);
        }
        Field reqField = null;
        try {
            reqField = request.getClass().getDeclaredField(requestField);
            reqField.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (reqField == null) {
            return RequestBody.serializeContentType(requestField, SERIALIZATION_METHOD_TO_CONTENT_TYPE.get(serializationMethod), request);
        }
        Object requestValue = reqField.get(request);
        if ((requestValue = Utils.resolveOptionals(requestValue)) == null) {
            return null;
        }
        RequestMetadata requestMetadata = RequestMetadata.parse(reqField);
        if (requestMetadata == null) {
            throw new RuntimeException("Missing request metadata on request field");
        }
        return RequestBody.serializeContentType(requestField, requestMetadata.mediaType, requestValue);
    }

    private static SerializedBody serializeContentType(String fieldName, String contentType, Object value) throws IllegalArgumentException, IllegalAccessException, UnsupportedOperationException, IOException {
        SerializedBody body;
        Pattern jsonPattern = Pattern.compile("(application|text)\\/.*?\\+*json.*");
        Pattern multipartPattern = Pattern.compile("multipart\\/.*");
        Pattern formPattern = Pattern.compile("application\\/x-www-form-urlencoded.*");
        Pattern textPattern = Pattern.compile("text\\/plain");
        if (textPattern.matcher(contentType).matches()) {
            body = new SerializedBody(contentType, HttpRequest.BodyPublishers.ofString(value.toString()));
        } else if (jsonPattern.matcher(contentType).matches()) {
            ObjectMapper mapper = JSON.getMapper();
            body = value instanceof JsonNullable && !((JsonNullable)value).isPresent() ? new SerializedBody(contentType, HttpRequest.BodyPublishers.noBody()) : new SerializedBody(contentType, HttpRequest.BodyPublishers.ofString(mapper.writeValueAsString(value)));
        } else if (multipartPattern.matcher(contentType).matches()) {
            body = RequestBody.serializeMultipart(value);
        } else if (formPattern.matcher(contentType).matches()) {
            body = RequestBody.serializeFormData(value);
        } else if (value instanceof String) {
            body = new SerializedBody(contentType, HttpRequest.BodyPublishers.ofString((String)value));
        } else if (value instanceof byte[]) {
            body = new SerializedBody(contentType, HttpRequest.BodyPublishers.ofByteArray((byte[])value));
        } else {
            throw new RuntimeException("Unsupported content type " + contentType + " for field " + fieldName);
        }
        return body;
    }

    private static SerializedBody serializeMultipart(Object value) throws IllegalArgumentException, IllegalAccessException, UnsupportedOperationException, IOException {
        Field[] fields;
        Multipart.Builder builder = Multipart.builder();
        for (Field field : fields = value.getClass().getDeclaredFields()) {
            List<?> arr;
            Object val;
            field.setAccessible(true);
            if (Modifier.isStatic(field.getModifiers()) || (val = Utils.resolveOptionals(field.get(value))) == null) continue;
            MultipartFormMetadata metadata = MultipartFormMetadata.parse(field);
            if (metadata == null) {
                throw new RuntimeException("Missing multipart form metadata on field " + field.getName());
            }
            if (metadata.file) {
                if (val instanceof List || val.getClass().isArray()) {
                    arr = Utils.toList(val);
                    for (Object item : arr) {
                        RequestBody.serializeMultipartFile(metadata.name + "[]", builder, item);
                    }
                    continue;
                }
                RequestBody.serializeMultipartFile(metadata.name, builder, val);
                continue;
            }
            if (metadata.json) {
                ObjectMapper mapper = JSON.getMapper();
                String json = mapper.writeValueAsString(val);
                builder.addPart(metadata.name, json, "application/json");
                continue;
            }
            if (val instanceof List || val.getClass().isArray()) {
                arr = Utils.toList(val);
                for (Object item : arr) {
                    builder.addPart(metadata.name + "[]", Utils.valToString(item));
                }
                continue;
            }
            builder.addPart(metadata.name, Utils.valToString(val));
        }
        Multipart m = builder.build();
        return new SerializedBody(m.contentType(), m.bodyPublisher());
    }

    private static void serializeMultipartFile(String fieldName, Multipart.Builder builder, Object file) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields;
        if (Types.getType(file.getClass()) != Types.OBJECT) {
            throw new RuntimeException("Invalid type for multipart file");
        }
        String fileName = "";
        byte[] content = null;
        for (Field field : fields = file.getClass().getDeclaredFields()) {
            MultipartFormMetadata metadata;
            field.setAccessible(true);
            Object val = field.get(file);
            if (val == null || (metadata = MultipartFormMetadata.parse(field)) == null || !metadata.content && (metadata.name == null || metadata.name.isBlank())) continue;
            if (metadata.content) {
                content = (byte[])val;
                continue;
            }
            fileName = Utils.valToString(val);
        }
        if (fileName.isBlank() || content == null) {
            throw new RuntimeException("Invalid multipart file");
        }
        String contentType = "application/octet-stream";
        try {
            String detectedType = Files.probeContentType(Path.of(fileName, new String[0]));
            if (detectedType != null && !detectedType.isEmpty()) {
                contentType = detectedType;
            }
        }
        catch (Exception detectedType) {
            // empty catch block
        }
        byte[] cont = content;
        builder.addPart(fieldName, () -> new ByteArrayInputStream(cont), fileName, Optional.of(contentType));
    }

    public static SerializedBody serializeFormData(Object value) throws IOException, IllegalArgumentException, IllegalAccessException {
        ArrayList<NameValue> params = new ArrayList<NameValue>();
        switch (Types.getType(value.getClass())) {
            case MAP: {
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    params.add(new NameValue(Utils.valToString(entry.getKey()), Utils.valToString(entry.getValue())));
                }
                break;
            }
            case OBJECT: {
                Field[] fields;
                if (!Utils.allowIntrospection(value.getClass())) {
                    throw new RuntimeException("Invalid type for form data");
                }
                block10: for (Field field : fields = value.getClass().getDeclaredFields()) {
                    FormMetadata metadata;
                    field.setAccessible(true);
                    Object val = Utils.resolveOptionals(field.get(value));
                    if (val == null || (metadata = FormMetadata.parse(field)) == null) continue;
                    if (metadata.json) {
                        ObjectMapper mapper = JSON.getMapper();
                        String json = mapper.writeValueAsString(val);
                        params.add(new NameValue(metadata.name, json));
                        continue;
                    }
                    switch (Types.getType(val.getClass())) {
                        case OBJECT: {
                            if (!Utils.allowIntrospection(val.getClass())) {
                                params.add(new NameValue(metadata.name, String.valueOf(val)));
                                continue block10;
                            }
                            Field[] valFields = val.getClass().getDeclaredFields();
                            ArrayList<String> items = new ArrayList();
                            for (Field field2 : valFields) {
                                FormMetadata valMetadata;
                                field2.setAccessible(true);
                                Object v = Utils.resolveOptionals(field2.get(val));
                                if (v == null || (valMetadata = FormMetadata.parse(field2)) == null) continue;
                                if (metadata.explode) {
                                    params.add(new NameValue(valMetadata.name, Utils.valToString(v)));
                                    continue;
                                }
                                items.add(String.format("%s,%s", valMetadata.name, Utils.valToString(v)));
                            }
                            if (items.size() <= 0) continue block10;
                            params.add(new NameValue(metadata.name, String.join((CharSequence)",", items)));
                            continue block10;
                        }
                        case MAP: {
                            Map valMap = (Map)val;
                            ArrayList<String> items = new ArrayList<String>();
                            for (Map.Entry entry : valMap.entrySet()) {
                                if (metadata.explode) {
                                    params.add(new NameValue(Utils.valToString(entry.getKey()), Utils.valToString(entry.getValue())));
                                    continue;
                                }
                                items.add(String.format("%s,%s", entry.getKey(), entry.getValue()));
                            }
                            if (items.size() <= 0) continue block10;
                            params.add(new NameValue(metadata.name, String.join((CharSequence)",", items)));
                            continue block10;
                        }
                        case ARRAY: {
                            List<Object> array = Utils.toList(val);
                            ArrayList<String> items = new ArrayList();
                            for (Object e : array) {
                                if (metadata.explode) {
                                    params.add(new NameValue(metadata.name, Utils.valToString(e)));
                                    continue;
                                }
                                items.add(Utils.valToString(e));
                            }
                            if (items.size() <= 0) continue block10;
                            params.add(new NameValue(metadata.name, String.join((CharSequence)",", items)));
                            continue block10;
                        }
                        default: {
                            params.add(new NameValue(metadata.name, Utils.valToString(val)));
                        }
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("Invalid type for form data");
            }
        }
        String contentType = "application/x-www-form-urlencoded; charset=ISO-8859-1";
        return new SerializedBody(contentType, HttpRequest.BodyPublishers.ofInputStream(() -> {
            String query = QueryEncoding.formatQuery(params, StandardCharsets.ISO_8859_1, true);
            return new ByteArrayInputStream(query.getBytes(StandardCharsets.ISO_8859_1));
        }));
    }
}

