/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.TimeOffPoliciesPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisListEmployeeTimeOffPoliciesResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends TimeOffPoliciesPaginated> timeOffPoliciesPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisListEmployeeTimeOffPoliciesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends TimeOffPoliciesPaginated> timeOffPoliciesPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(timeOffPoliciesPaginated, "timeOffPoliciesPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.timeOffPoliciesPaginated = timeOffPoliciesPaginated;
        this.headers = headers;
    }

    public HrisListEmployeeTimeOffPoliciesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<TimeOffPoliciesPaginated> timeOffPoliciesPaginated() {
        return this.timeOffPoliciesPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisListEmployeeTimeOffPoliciesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisListEmployeeTimeOffPoliciesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisListEmployeeTimeOffPoliciesResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisListEmployeeTimeOffPoliciesResponse withTimeOffPoliciesPaginated(TimeOffPoliciesPaginated timeOffPoliciesPaginated) {
        Utils.checkNotNull(timeOffPoliciesPaginated, "timeOffPoliciesPaginated");
        this.timeOffPoliciesPaginated = Optional.ofNullable(timeOffPoliciesPaginated);
        return this;
    }

    public HrisListEmployeeTimeOffPoliciesResponse withTimeOffPoliciesPaginated(Optional<? extends TimeOffPoliciesPaginated> timeOffPoliciesPaginated) {
        Utils.checkNotNull(timeOffPoliciesPaginated, "timeOffPoliciesPaginated");
        this.timeOffPoliciesPaginated = timeOffPoliciesPaginated;
        return this;
    }

    public HrisListEmployeeTimeOffPoliciesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisListEmployeeTimeOffPoliciesResponse other = (HrisListEmployeeTimeOffPoliciesResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.timeOffPoliciesPaginated, other.timeOffPoliciesPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.timeOffPoliciesPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisListEmployeeTimeOffPoliciesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "timeOffPoliciesPaginated", this.timeOffPoliciesPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends TimeOffPoliciesPaginated> timeOffPoliciesPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder timeOffPoliciesPaginated(TimeOffPoliciesPaginated timeOffPoliciesPaginated) {
            Utils.checkNotNull(timeOffPoliciesPaginated, "timeOffPoliciesPaginated");
            this.timeOffPoliciesPaginated = Optional.ofNullable(timeOffPoliciesPaginated);
            return this;
        }

        public Builder timeOffPoliciesPaginated(Optional<? extends TimeOffPoliciesPaginated> timeOffPoliciesPaginated) {
            Utils.checkNotNull(timeOffPoliciesPaginated, "timeOffPoliciesPaginated");
            this.timeOffPoliciesPaginated = timeOffPoliciesPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisListEmployeeTimeOffPoliciesResponse build() {
            return new HrisListEmployeeTimeOffPoliciesResponse(this.contentType, this.statusCode, this.rawResponse, this.timeOffPoliciesPaginated, this.headers);
        }
    }
}

