/*
 * Decompiled with CFR 0.152.
 */
package com.syntaxphoenix.syntaxapi.version;

import com.syntaxphoenix.syntaxapi.version.Version;
import com.syntaxphoenix.syntaxapi.version.VersionState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;

public class VersionManager<V extends Version> {
    protected final EnumMap<VersionState, ArrayList<V>> versions = new EnumMap(VersionState.class);
    protected final VersionState unknown;
    protected final VersionState higher;
    protected final VersionState lower;

    public VersionManager() {
        this(VersionState.NOT_COMPATIBLE, VersionState.NOT_COMPATIBLE, VersionState.NOT_COMPATIBLE);
    }

    public VersionManager(VersionState unknown, VersionState higher, VersionState lower) {
        this.versions.put(VersionState.SUPPORTED, new ArrayList());
        this.versions.put(VersionState.NOT_SUPPORTED, new ArrayList());
        this.versions.put(VersionState.NOT_TESTED, new ArrayList());
        this.versions.put(VersionState.NOT_COMPATIBLE, new ArrayList());
        this.unknown = unknown;
        this.higher = higher;
        this.lower = lower;
    }

    public VersionState getDefaultStateForUnknownVersions() {
        return this.unknown;
    }

    public VersionState getDefaultStateForHigherVersions() {
        return this.higher;
    }

    public VersionState getDefaultStateForLowerVersions() {
        return this.lower;
    }

    public VersionManager<V> sortAll() {
        for (VersionState state : VersionState.values()) {
            this.sort(state);
        }
        return this;
    }

    public VersionManager<V> sort(VersionState state) {
        ArrayList<V> versions = this.versions.get((Object)state);
        if (versions.isEmpty()) {
            return this;
        }
        Collections.sort(versions);
        return this;
    }

    public VersionManager<V> clearAll() {
        for (VersionState state : VersionState.values()) {
            this.clear(state);
        }
        return this;
    }

    public VersionManager<V> clear(VersionState state) {
        ArrayList<V> versions = this.versions.get((Object)state);
        if (versions.isEmpty()) {
            return this;
        }
        versions.clear();
        return this;
    }

    public VersionManager<V> setAll(VersionState state, V ... versions) {
        for (V version : versions) {
            this.set(state, version, false);
        }
        this.sort(state);
        return this;
    }

    public VersionManager<V> set(VersionState state, V version) {
        return this.set(state, version, true);
    }

    public VersionManager<V> set(VersionState state, V version, boolean sort) {
        if (state == null) {
            VersionState remove = this.getState(version);
            if (remove != null) {
                this.versions.get((Object)remove).remove(version);
            }
        } else {
            VersionState remove = this.getActualState(version);
            if (remove != state) {
                if (remove != null) {
                    this.versions.get((Object)remove).remove(version);
                }
                this.versions.get((Object)state).add(version);
            }
        }
        if (sort) {
            this.sort(state);
        }
        return this;
    }

    public VersionManager<V> addAll(V ... versions) {
        return this.setAll(this.unknown, (Version[])versions);
    }

    public VersionManager<V> add(V version) {
        return this.set(this.unknown, version);
    }

    public VersionManager<V> removeAll(V ... versions) {
        return this.setAll(null, (Version[])versions);
    }

    public VersionManager<V> remove(V version) {
        return this.set(null, version);
    }

    public boolean contains(V version) {
        return this.getActualState(version) != null;
    }

    public boolean contains(VersionState state, V version) {
        return this.versions.get((Object)state).contains(version);
    }

    public V getHighestVersion(VersionState state) {
        ArrayList<V> versions = this.versions.get((Object)state);
        if (versions.isEmpty()) {
            return null;
        }
        return (V)((Version)versions.get(versions.size() - 1));
    }

    public V getHighestVersionOf(VersionState ... states) {
        if (states == null || states.length == 0) {
            return null;
        }
        if (states.length == 1) {
            return this.getLowestVersion(states[0]);
        }
        Version highest = null;
        for (int index = 0; index < states.length; ++index) {
            V current = this.getHighestVersion(states[index]);
            if (highest != null && !((Version)current).isHigher(highest)) continue;
            highest = (Version)current;
        }
        return (V)highest;
    }

    public V getLowestVersion(VersionState state) {
        ArrayList<V> versions = this.versions.get((Object)state);
        if (versions.isEmpty()) {
            return null;
        }
        return (V)((Version)versions.get(0));
    }

    public V getLowestVersionOf(VersionState ... states) {
        if (states == null || states.length == 0) {
            return null;
        }
        if (states.length == 1) {
            return this.getLowestVersion(states[0]);
        }
        Version lowest = null;
        for (int index = 0; index < states.length; ++index) {
            V current = this.getLowestVersion(states[index]);
            if (lowest != null && !((Version)current).isLower(lowest)) continue;
            lowest = (Version)current;
        }
        return (V)lowest;
    }

    public ArrayList<V> getVersions(VersionState state) {
        return (ArrayList)this.versions.get((Object)state).clone();
    }

    public VersionState getActualState(V version) {
        for (VersionState state : VersionState.values()) {
            if (!this.contains(state, version)) continue;
            return state;
        }
        return null;
    }

    public VersionState getState(V version) {
        VersionState[] states = VersionState.values();
        for (int index = 0; index < states.length; ++index) {
            if (!this.contains(states[index], version)) continue;
            return states[index];
        }
        V lowest = this.getLowestVersionOf(VersionState.SUPPORTED, VersionState.NOT_TESTED);
        if (lowest != null && ((Version)version).isLower((Version)lowest)) {
            return this.lower;
        }
        V highest = this.getHighestVersionOf(VersionState.SUPPORTED, VersionState.NOT_TESTED);
        if (highest != null && ((Version)version).isHigher((Version)highest)) {
            return this.higher;
        }
        return this.unknown;
    }
}

