/*
 * Decompiled with CFR 0.152.
 */
package com.telapi.api.http;

import com.telapi.api.configuration.TelapiConfiguration;
import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;

public class RestExecutor {
    public static ApacheHttpClient4Executor createExecutor(TelapiConfiguration conf) {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(conf.getSid(), conf.getAuthToken());
        ApacheHttpClient4Executor executor = new ApacheHttpClient4Executor();
        DefaultHttpClient httpClient = (DefaultHttpClient)executor.getHttpClient();
        if (conf.getProxyHost() != null && !conf.getProxyHost().trim().isEmpty()) {
            HttpHost proxy = new HttpHost(conf.getProxyHost(), Integer.parseInt(conf.getProxyPort()), conf.getProxyProtocol());
            httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        }
        httpClient.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuthInterceptor(), 0);
        httpClient.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)credentials);
        BasicHttpContext localContext = new BasicHttpContext();
        BasicScheme basicAuth = new BasicScheme();
        localContext.setAttribute("preemptive-auth", (Object)basicAuth);
        executor.setHttpContext((HttpContext)localContext);
        return executor;
    }

    private RestExecutor() {
    }

    static class PreemptiveAuthInterceptor
    implements HttpRequestInterceptor {
        PreemptiveAuthInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                AuthScheme authScheme = (AuthScheme)context.getAttribute("preemptive-auth");
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                if (authScheme != null) {
                    Credentials creds = credsProvider.getCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()));
                    if (creds == null) {
                        throw new HttpException("No credentials for preemptive authentication");
                    }
                    authState.setAuthScheme(authScheme);
                    authState.setCredentials(creds);
                }
            }
        }
    }
}

