/*
 * Decompiled with CFR 0.152.
 */
package com.telapi.api.inboundxml.elements;

import com.telapi.api.domain.enums.HttpMethod;
import com.telapi.api.inboundxml.elements.Conference;
import com.telapi.api.inboundxml.elements.Dial;
import com.telapi.api.inboundxml.elements.Gather;
import com.telapi.api.inboundxml.elements.GetSpeech;
import com.telapi.api.inboundxml.elements.Hangup;
import com.telapi.api.inboundxml.elements.Number;
import com.telapi.api.inboundxml.elements.Pause;
import com.telapi.api.inboundxml.elements.Play;
import com.telapi.api.inboundxml.elements.Record;
import com.telapi.api.inboundxml.elements.Redirect;
import com.telapi.api.inboundxml.elements.Reject;
import com.telapi.api.inboundxml.elements.ResponseElement;
import com.telapi.api.inboundxml.elements.Say;
import com.telapi.api.inboundxml.elements.Sip;
import com.telapi.api.inboundxml.elements.Sms;
import com.telapi.api.inboundxml.elements.enums.RecordingFileFormat;
import com.telapi.api.inboundxml.elements.enums.RejectReason;
import com.telapi.api.inboundxml.elements.enums.Voice;
import com.telapi.api.inboundxml.parameters.RecordParameters;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;

@XStreamAlias(value="Response")
public class Response {
    @XStreamImplicit
    private List<ResponseElement> elements = new ArrayList<ResponseElement>();
    private static XStream xstream = new XStream();

    protected Response() {
    }

    public static Response create() {
        return new Response();
    }

    public Response play(Long loop, String resource) {
        this.elements.add(Play.createPlay(loop, resource));
        return this;
    }

    public Response say(String text, Voice voice, Long loop) {
        this.elements.add(Say.createSay(text, voice, loop));
        return this;
    }

    public Response say(String text) {
        this.elements.add(Say.createSay(text, null, null));
        return this;
    }

    public Response record(String action, HttpMethod method, Long timeout, String finishOnKey, Long maxLength, Boolean transcribe, String transcribeCallback, Boolean playBeep, Boolean bothLegs, RecordingFileFormat fileFormat) {
        this.elements.add(Record.createRecord(action, method, timeout, finishOnKey, maxLength, transcribe, transcribeCallback, playBeep, bothLegs, fileFormat));
        return this;
    }

    public Response record(String action) {
        this.elements.add(Record.createRecord(action));
        return this;
    }

    public Response record(RecordParameters params) {
        this.elements.add(Record.createRecord(params.getAction(), params.getMethod(), params.getTimeout(), params.getFinishOnKey(), params.getMaxLength(), params.getTranscribe(), params.getTranscribeCallback(), params.getPlayBeep(), params.getBothLegs(), params.getFileFormat()));
        return this;
    }

    public Response dial(Dial dial) {
        this.elements.add(dial);
        return this;
    }

    public Response hangup(Long schedule) {
        this.elements.add(Hangup.createHangup(schedule));
        return this;
    }

    public Response hangup() {
        this.elements.add(Hangup.createHangup(null));
        return this;
    }

    public Response redirect(String url) {
        this.elements.add(Redirect.createRedirect(url, null));
        return this;
    }

    public Response redirect(String url, HttpMethod method) {
        this.elements.add(Redirect.createRedirect(url, method));
        return this;
    }

    public Response reject(RejectReason reason) {
        this.elements.add(Reject.createReject(reason));
        return this;
    }

    public Response reject() {
        this.elements.add(Reject.createReject(null));
        return this;
    }

    public Response pause(Long length) {
        this.elements.add(Pause.createPause(length));
        return this;
    }

    public Response pause() {
        this.elements.add(Pause.createPause(null));
        return this;
    }

    public Response sms(String text, String to, String from, String action, HttpMethod method, String statusCallback) {
        this.elements.add(Sms.createSms(text, to, from, action, method, statusCallback));
        return this;
    }

    public Response sms(String text, String to, String from) {
        this.elements.add(Sms.createSms(text, to, from, null, null, null));
        return this;
    }

    public Response gather(Gather gather) {
        this.elements.add(gather);
        return this;
    }

    public Response getSpeech(GetSpeech getSpeech) {
        this.elements.add(getSpeech);
        return this;
    }

    public String createXml() {
        return xstream.toXML((Object)this);
    }

    static {
        xstream.processAnnotations(new Class[]{Response.class, Record.class, Play.class, Say.class, Number.class, Dial.class, Conference.class, Sip.class, Hangup.class, Redirect.class, Reject.class, Gather.class, Sms.class, Pause.class, GetSpeech.class});
    }
}

