/*
 * Decompiled with CFR 0.152.
 */
package com.testmonitor.actions;

import com.testmonitor.api.Connector;
import com.testmonitor.parsers.ProjectParser;
import com.testmonitor.resources.Project;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.json.JSONObject;

public class Projects {
    private final Connector connector;

    public Projects(Connector connector) {
        this.connector = connector;
    }

    public ArrayList<Project> list() {
        return this.list(1);
    }

    public ArrayList<Project> list(Integer page) {
        return this.list(page, 15);
    }

    public ArrayList<Project> list(Integer page, Integer limit) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("page", page.toString()));
        params.add((NameValuePair)new BasicNameValuePair("limit", limit.toString()));
        return ProjectParser.parse(this.connector.get("projects", params));
    }

    public Project get(Integer id) {
        JSONObject response = this.connector.get("projects/" + id);
        HashMap project = (HashMap)response.getJSONObject("data").toMap();
        return ProjectParser.parse(project);
    }

    public Project update(Project project) {
        JSONObject response = this.connector.put("projects/" + project.getId(), project.toHttpParams());
        HashMap updatedProject = (HashMap)response.getJSONObject("data").toMap();
        return ProjectParser.parse(updatedProject);
    }
}

