/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.loginsightapi;

import com.vmware.loginsightapi.core.FieldConstraint;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public abstract class QueryBuilder {
    public static final int DEFAULT_LIMIT = 100;
    public static final int DEFAULT_TIMEOUT = 30000;
    protected List<FieldConstraint> constraints;
    protected int limit = 100;
    protected int timeout = 30000;
    protected List<String> contentPackFields = new ArrayList<String>();
    protected boolean includeDefaults = false;

    public QueryBuilder() {
        this.constraints = new ArrayList<FieldConstraint>();
    }

    public QueryBuilder limit(int limit) {
        this.limit = limit;
        return this;
    }

    public QueryBuilder timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public QueryBuilder setContentPackFields(List<String> contentPackFields) {
        this.contentPackFields = contentPackFields;
        return this;
    }

    public QueryBuilder addContentPackField(String contentPackField) {
        this.contentPackFields.add(contentPackField);
        return this;
    }

    public QueryBuilder addContentPackFields(List<String> contentPackFields) {
        this.contentPackFields.addAll(contentPackFields);
        return this;
    }

    public QueryBuilder setConstraints(List<FieldConstraint> constraints) {
        this.constraints = constraints;
        return this;
    }

    public QueryBuilder addConstraint(String name, FieldConstraint.Operator operator, String value) {
        this.constraints.add(new FieldConstraint(name, operator, value));
        return this;
    }

    public QueryBuilder addConstraints(List<FieldConstraint> constraints) {
        this.constraints.addAll(constraints);
        return this;
    }

    public QueryBuilder withDefaults() {
        this.includeDefaults = true;
        return this;
    }

    protected String buildPathSegment() {
        String expression = this.constraints.stream().map(constraint -> {
            try {
                return constraint.toExpressionEncoded();
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("Unable to encode the field constraint " + constraint.toExpression());
            }
        }).collect(Collectors.joining("/"));
        return expression;
    }

    protected String buildUrlParameters() {
        ArrayList<String> urlParams = new ArrayList<String>();
        if (this.limit != 100 || this.includeDefaults) {
            urlParams.add("limit=" + this.limit);
        }
        if (this.timeout != 30000 || this.includeDefaults) {
            urlParams.add("timeout=" + this.timeout);
        }
        List contentPackParams = this.contentPackFields.stream().map(contentPack -> "content-pack-fields=" + contentPack).collect(Collectors.toList());
        urlParams.addAll(contentPackParams);
        return urlParams.parallelStream().collect(Collectors.joining("&"));
    }

    public abstract String toUrlString();
}

