/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.loginsightapi;

import com.vmware.loginsightapi.core.LogInsightApiException;
import com.vmware.loginsightapi.core.Message;

public class MessageBuilder {
    private Message message;

    public MessageBuilder() {
        this.message = new Message();
    }

    public MessageBuilder(String text) {
        this.message = new Message(text);
    }

    public MessageBuilder field(String name, String content) {
        this.message.addField(name, content);
        return this;
    }

    public MessageBuilder field(String name, int startPosition, int length) {
        this.message.addField(name, startPosition, length);
        return this;
    }

    public MessageBuilder timestamp(long timeStamp) {
        this.message.setTimestamp(timeStamp);
        return this;
    }

    public MessageBuilder currentTimestamp() {
        this.message.setTimestamp();
        return this;
    }

    public Message build() {
        if (this.message.checkIsValid()) {
            return this.message;
        }
        throw new LogInsightApiException("Invalid message structure.");
    }
}

