/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.loginsightapi.core;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class FieldConstraint {
    private final String name;
    private final Operator operator;
    private final Object value;

    public FieldConstraint(String name, Operator operator, Object value) {
        this.name = name;
        this.operator = operator;
        this.value = value;
    }

    public FieldConstraint(String name, Operator operator) {
        this.name = name;
        this.operator = operator;
        this.value = null;
    }

    public static FieldConstraint eq(String name, String value) {
        return new FieldConstraint(name, Operator.EQ, value);
    }

    public static FieldConstraint ne(String name, String value) {
        return new FieldConstraint(name, Operator.NE, value);
    }

    public static FieldConstraint lt(String name, String value) {
        return new FieldConstraint(name, Operator.LT, value);
    }

    public static FieldConstraint le(String name, String value) {
        return new FieldConstraint(name, Operator.LE, value);
    }

    public static FieldConstraint gt(String name, String value) {
        return new FieldConstraint(name, Operator.GT, value);
    }

    public static FieldConstraint ge(String name, String value) {
        return new FieldConstraint(name, Operator.GE, value);
    }

    public static FieldConstraint contains(String name, String value) {
        return new FieldConstraint(name, Operator.CONTAINS, value);
    }

    public static FieldConstraint notContains(String name, String value) {
        return new FieldConstraint(name, Operator.NOT_CONTAINS, value);
    }

    public static FieldConstraint has(String name, String value) {
        return new FieldConstraint(name, Operator.HAS, value);
    }

    public static FieldConstraint notHas(String name, String value) {
        return new FieldConstraint(name, Operator.NOT_HAS, value);
    }

    public static FieldConstraint matchesRegex(String name, String value) {
        return new FieldConstraint(name, Operator.MATCHES_REGEX, value);
    }

    public static FieldConstraint notMatchesRegex(String name, String value) {
        return new FieldConstraint(name, Operator.NOT_MATCHES_REGEX, value);
    }

    public static FieldConstraint exists(String name) {
        return new FieldConstraint(name, Operator.EXISTS);
    }

    public String toExpression() {
        StringBuilder sb = new StringBuilder().append(this.name).append("/").append((Object)this.operator).append(" ").append(this.value.toString());
        return sb.toString();
    }

    public String toExpressionEncoded() throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append("/").append(this.operator.toString());
        switch (this.operator) {
            case MATCHES_REGEX: 
            case NOT_MATCHES_REGEX: 
            case CONTAINS: 
            case NOT_CONTAINS: 
            case HAS: 
            case NOT_HAS: {
                sb.append(URLEncoder.encode(" ", "UTF-8"));
                sb.append(URLEncoder.encode(this.value.toString(), "UTF-8"));
                break;
            }
            case EXISTS: {
                break;
            }
            default: {
                sb.append(URLEncoder.encode(" ", "UTF-8"));
                sb.append(this.value);
            }
        }
        return sb.toString();
    }

    public static enum Operator {
        EQ,
        NE,
        LT,
        LE,
        GT,
        GE,
        CONTAINS,
        NOT_CONTAINS,
        HAS,
        NOT_HAS,
        MATCHES_REGEX,
        NOT_MATCHES_REGEX,
        EXISTS;

    }
}

