/*
 * Copyright 2019 VMware, Inc.
 * SPDX-License-Identifier: EPL-2.0
 */
package com.vmware.vipclient.i18n.util;

/**
 * This class define some constant keys used in the codes.
 * 
 */
public class ConstantsKeys {

	public static final String HTTP_PROTOCOL = "http";
	public static final String HTTPS_PROTOCOL = "https";
	public static final String HTTP_PROTOCOL_PREFIX = "http://";
	public static final String HTTPS_PROTOCOL_PREFIX = "https://";
	public static final String DEFAULT_PROTOCOL = HTTPS_PROTOCOL;
	public static final String UTF8 = "utf-8";
	public static final String POST = "POST";
	public static final String GET = "GET";
	public static final String PRODUCTID = "productID";
	public static final String KEY = "key";
	public static final String SOURCE = "source";
	public static final String VERSION = "version";
	public static final String COMPONENT = "component";
	public static final String COMPONENTS = "components";
	public static final String LOCALE = "locale";
	public static final String LOCALE_L3 = "LOCALE_L3";
	public static final String LOCALE_L2 = "LOCALE_L2";
	public static final String DATA = "data";
	public static final String RESPONSE = "response";
	public static final String CODE = "code";
	public static final String STATUS = "status";
	public static final String MESSAGE = "message";
	public static final String MESSAGES = "messages";
	public static final String TRANSLATION = "translation";
	public static final String UNDERLINE = "_";
	public static final String UNDERLINE_POUND = "_#";
	public static final Integer MAX_NUM_OF_SOURCE_TYPE_IN_CACHE = 30000;
	public static final Integer MAX_NUM_OF_TRANSLATION_SOURCE_TYPE = 30000;
	protected static final String[] DEFAULT_LOCALES = { "en" };
	public static final String BUNDLES = "bundles";
	public static final String LOCALES = "locales";
	public static final String LATEST = "latest";
	public static final String PSEUDO = "pseudo";
	public static final String MACHINE_TRANSLATION = "machineTranslation";
	public static final String COLLECT_SOURCE = "collectSource";
	public static final String PSEUDOCHAR = "#@";
	public static final String PSEUDOCHAR2 = "@@";
	public static final String COMMA = ",";
	public static final String EN = "en";
	public static final String EN_US = "en_US";
	public static final String USD = "USD";
	public static final int HTTP_CONNECT_TIMEOUT = 5000;
	public static final int HTTP_READ_TIMEOUT = 5000;
	public static final String DEFAULT_COMPONENT = "default";
	public static final String FORMATTED_DATE = "formattedDate";
	public static final String FORMATTED_NUMBER = "formattedNumber";
	public static final String SUPPORTED_LANGUAGE_LIST = "supportedLanguageList";
	public static final String DISPLAY_LANGUAGE = "displayLanguage";
	public static final String PRODUCT_NAME = "productName";
	public static final String PRODUCT_VERSION = "version";
	public static final String LANGUAGES = "languages";
	public static final String LANGUAGE = "language";
	public static final String TERRITORIES = "territories";
	public static final String LANGUAGE_TAG = "languageTag";
	public static final String DISPLAY_NAME = "displayName";
	public static final String JSON_KEYSET = "jsonkeyset";
	public static final String TRANSLATION_STATUS = "translationStatus";

}
