/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.base.instances;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.instances.Message;
import com.vmware.vipclient.i18n.messages.dto.MessagesDTO;
import com.vmware.vipclient.i18n.messages.service.ComponentService;
import com.vmware.vipclient.i18n.messages.service.StringService;
import com.vmware.vipclient.i18n.util.FormatUtils;
import com.vmware.vipclient.i18n.util.JSONUtils;
import com.vmware.vipclient.i18n.util.LocaleUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationMessage
implements Message {
    Logger logger = LoggerFactory.getLogger(TranslationMessage.class);

    public String getString(Locale locale, String component, String key, String source, String comment, Object ... args) {
        this.logger.debug("Start to execute TranslationMessage.getString");
        if (key == null || key.equalsIgnoreCase("")) {
            return "";
        }
        MessagesDTO dto = new MessagesDTO();
        dto.setComponent(component);
        dto.setComment(comment);
        dto.setKey(key);
        dto.setSource(source);
        dto.setLocale(locale.toLanguageTag());
        StringService s = new StringService(dto);
        String translation = "";
        if (!LocaleUtility.isDefaultLocale(locale)) {
            translation = s.getString();
            if (source != null && !"".equals(source) && !VIPCfg.getInstance().isPseudo()) {
                dto.setLocale(LocaleUtility.defaultLocale.toLanguageTag());
                String remoteEnMsg = s.getString();
                if (!source.equals(remoteEnMsg)) {
                    translation = source;
                }
            }
            if ("".equals(translation)) {
                translation = source;
            }
        } else {
            translation = source;
        }
        if (VIPCfg.getInstance().isCollectSource() || VIPCfg.getInstance().isMachineTranslation()) {
            dto.setLocale("latest");
            String latestStr = s.getString();
            if (source != null && !source.equals(latestStr)) {
                dto.setLocale(locale.toLanguageTag());
                String mt = s.postString();
                if (VIPCfg.getInstance().isMachineTranslation() && !"".equalsIgnoreCase(mt)) {
                    translation = mt;
                }
            }
        }
        if (!VIPCfg.getInstance().isMachineTranslation() && VIPCfg.getInstance().isPseudo() && null != translation && translation.equals(source)) {
            translation = "@@" + translation + "@@";
        }
        if (args != null && args.length > 0) {
            translation = null != translation && translation.equals(source) || VIPCfg.getInstance().isPseudo() ? FormatUtils.format(translation, LocaleUtility.defaultLocale, args) : FormatUtils.format(translation, locale, args);
        }
        return translation;
    }

    public boolean postStrings(Locale locale, String component, List<JSONObject> sources) {
        this.logger.info("Start to execute TranslationMessage.postStrings");
        if (sources == null || sources.isEmpty()) {
            return false;
        }
        MessagesDTO dto = new MessagesDTO();
        dto.setLocale(locale.toLanguageTag());
        dto.setComponent(component);
        ArrayList<JSONObject> sourcesList = new ArrayList<JSONObject>();
        sourcesList.addAll(sources);
        ArrayList<JSONObject> removedList = new ArrayList<JSONObject>();
        for (JSONObject jo : sourcesList) {
            String key = (String)jo.get((Object)"key");
            String source = (String)jo.get((Object)"source");
            dto.setKey(key);
            dto.setSource(source);
            dto.setLocale("latest");
            String enStr = new StringService(dto).getString();
            if (source == null || !source.equals(enStr)) continue;
            removedList.add(jo);
        }
        sourcesList.removeAll(removedList);
        if (sourcesList.isEmpty()) {
            return true;
        }
        dto.setLocale(locale.toLanguageTag());
        StringService s = new StringService(dto);
        return s.postStrings(sourcesList);
    }

    public boolean postString(Locale locale, String component, String key, String source, String comment) {
        this.logger.info("Start to execute TranslationMessage.postString");
        MessagesDTO dto = new MessagesDTO();
        dto.setComponent(component);
        dto.setComment(comment);
        dto.setKey(key);
        dto.setSource(source);
        StringService s = new StringService(dto);
        dto.setLocale("latest");
        String enStr = s.getString();
        if (source != null && !"".equalsIgnoreCase(source) && !source.equals(enStr)) {
            dto.setLocale(locale.toLanguageTag());
            String recievedStr = s.postString();
            return !JSONUtils.isEmpty(recievedStr);
        }
        return true;
    }

    public Map<String, String> getStrings(Locale locale, String component) {
        this.logger.info("Start to execute TranslationMessage.getStrings");
        MessagesDTO dto = new MessagesDTO();
        dto.setLocale(locale.toLanguageTag());
        dto.setComponent(component);
        ComponentService cs = new ComponentService(dto);
        return cs.getComponentTranslation();
    }

    public String getString2(String component, String bundle, Locale locale, String key, Object ... args) {
        String source;
        this.logger.debug("Start to execute TranslationMessage.getString2");
        if (key == null || key.equalsIgnoreCase("")) {
            return "";
        }
        String message = "";
        try {
            ResourceBundle rb = ResourceBundle.getBundle(bundle, LocaleUtility.defaultLocale);
            source = rb.getString(key);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            source = key;
        }
        message = this.getString(locale, component, key, source, "", args);
        return message;
    }

    public boolean isAvailable(String component, Locale locale) {
        this.logger.info("Start to execute component-based TranslationMessage.isAvailable");
        boolean available = false;
        if (!LocaleUtility.isDefaultLocale(locale)) {
            MessagesDTO dto = new MessagesDTO();
            dto.setComponent(component);
            dto.setLocale(locale.toLanguageTag());
            ComponentService cs = new ComponentService(dto);
            available = cs.isComponentAvailable();
        }
        return available;
    }

    public boolean isAvailable(String component, String key, Locale locale) {
        this.logger.info("Start to execute string-based TranslationMessage.isAvailable");
        boolean available = false;
        if (!LocaleUtility.isDefaultLocale(locale)) {
            MessagesDTO dto = new MessagesDTO();
            dto.setComponent(component);
            dto.setKey(key);
            dto.setLocale(locale.toLanguageTag());
            StringService s = new StringService(dto);
            available = s.isStringAvailable();
        }
        return available;
    }
}

