/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.api.opt.local;

import com.vmware.i18n.PatternUtil;
import com.vmware.i18n.pattern.service.impl.PatternServiceImpl;
import com.vmware.i18n.utils.CommonUtil;
import com.vmware.vipclient.i18n.base.DataSourceEnum;
import com.vmware.vipclient.i18n.messages.api.opt.LocaleOpt;
import com.vmware.vipclient.i18n.messages.dto.LocaleDTO;
import com.vmware.vipclient.i18n.messages.service.FormattingCacheService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalLocaleOpt
implements LocaleOpt {
    private Logger logger = LoggerFactory.getLogger(LocalLocaleOpt.class);
    private static final String BUNDLE_PREFIX = "messages_";
    private static final String BUNDLE_SUFFIX = ".json";
    private LocaleDTO dto = null;

    public LocalLocaleOpt(LocaleDTO dto) {
        this.dto = dto;
    }

    @Override
    public Map<String, String> getSupportedLanguages(String locale) {
        HashMap<String, String> supportedLanguageNames = new HashMap<String, String>();
        List<String> supportedLanguages = DataSourceEnum.Bundle.createProductOpt(this.dto).getSupportedLocales();
        if (supportedLanguages != null && !supportedLanguages.isEmpty()) {
            Map<String, String> languagesNames = this.getLanguagesNamesFromCLDR(locale);
            if (languagesNames == null || languagesNames.isEmpty()) {
                return supportedLanguageNames;
            }
            for (String language : supportedLanguages) {
                if ("source".equalsIgnoreCase(language)) continue;
                supportedLanguageNames.put(language, languagesNames.get(language));
            }
        }
        return supportedLanguageNames;
    }

    private Map<String, String> getLanguagesNamesFromCLDR(String locale) {
        JSONObject languagesNames = null;
        this.logger.debug("Look for languages' names from cache for locale [{}]!", (Object)locale);
        FormattingCacheService formattingCacheService = new FormattingCacheService();
        languagesNames = formattingCacheService.getLanguagesNames(locale);
        if (languagesNames != null) {
            this.logger.debug("Find languages' names from cache for locale [{}]!", (Object)locale);
            return languagesNames;
        }
        languagesNames = this.getLanguagesNamesFromBundle(locale);
        if (languagesNames != null) {
            this.logger.debug("Find the languages' names from local bundle for locale [{}].\n", (Object)locale);
            formattingCacheService.addLanguagesNames(locale, (Map<String, String>)languagesNames);
            this.logger.debug("Languages' names are cached for locale [{}]!\n\n", (Object)locale);
            return languagesNames;
        }
        return null;
    }

    private JSONObject getLanguagesNamesFromBundle(String locale) {
        this.logger.debug("Look for languages' names from local package bundle for locale [{}]!", (Object)locale);
        String normalizedLocale = CommonUtil.getCLDRLocale((String)locale, (Map)PatternServiceImpl.localePathMap, (Map)PatternServiceImpl.localeAliasesMap);
        this.logger.info("Normalized locale for locale [{}] is [{}]", (Object)locale, (Object)normalizedLocale);
        if (normalizedLocale == null || normalizedLocale.isEmpty()) {
            return null;
        }
        try {
            String languagesJsonStr = PatternUtil.getLanguageFromLib((String)normalizedLocale);
            JSONObject languagesData = (JSONObject)new JSONParser().parse(languagesJsonStr);
            return (JSONObject)languagesData.get((Object)"languages");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
            return null;
        }
    }

    public JSONObject getRegions(String locale) {
        this.logger.debug("Look for regions from local bundle for locale [{}]!", (Object)locale);
        String normalizedLocale = CommonUtil.getCLDRLocale((String)locale, (Map)PatternServiceImpl.localePathMap, (Map)PatternServiceImpl.localeAliasesMap);
        this.logger.info("Normalized locale for locale [{}] is [{}]", (Object)locale, (Object)normalizedLocale);
        if (normalizedLocale == null || normalizedLocale.isEmpty()) {
            return null;
        }
        try {
            String regionsJsonStr = PatternUtil.getRegionFromLib((String)normalizedLocale);
            JSONObject regionsData = (JSONObject)new JSONParser().parse(regionsJsonStr);
            return (JSONObject)regionsData.get((Object)"territories");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
            return null;
        }
    }
}

