/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.api.opt.local;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.DataSourceEnum;
import com.vmware.vipclient.i18n.base.cache.MessageCacheItem;
import com.vmware.vipclient.i18n.messages.api.opt.MessageOpt;
import com.vmware.vipclient.i18n.messages.api.opt.Opt;
import com.vmware.vipclient.i18n.messages.dto.MessagesDTO;
import com.vmware.vipclient.i18n.util.FormatUtils;
import com.vmware.vipclient.i18n.util.JSONBundleUtil;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalMessagesOpt
implements Opt,
MessageOpt {
    private Logger logger = LoggerFactory.getLogger((String)LocalMessagesOpt.class.getName());
    private static final String OFFLINE_RESOURCE_PATH = "{0}/messages_{1}.json";
    private MessagesDTO dto;

    public LocalMessagesOpt(MessagesDTO dto) {
        this.dto = dto;
    }

    @Deprecated
    public JSONObject getComponentMessages() {
        return JSONBundleUtil.getMessages(this.dto.getLocale(), this.dto.getProductID(), this.dto.getVersion(), this.dto.getComponent());
    }

    @Override
    public void getComponentMessages(MessageCacheItem cacheItem) {
        Locale bestMatch = Locale.lookup(Arrays.asList(new Locale.LanguageRange(this.dto.getLocale())), this.getSupportedLocales());
        try {
            String filePath = FormatUtils.format(OFFLINE_RESOURCE_PATH, this.dto.getComponent(), bestMatch.toLanguageTag());
            Path path = Paths.get(VIPCfg.getInstance().getOfflineResourcesBaseUrl(), filePath);
            URI uri = Thread.currentThread().getContextClassLoader().getResource(path.toString()).toURI();
            JSONObject messages = null;
            if (uri.getScheme().equals("jar")) {
                try (FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                    path = fileSystem.getPath(path.toString(), new String[0]);
                    messages = JSONBundleUtil.getMessages(path);
                }
            } else {
                path = Paths.get(uri);
                messages = JSONBundleUtil.getMessages(path);
            }
            cacheItem.setCacheItem(this.dto.getLocale(), (Map<String, String>)messages, null, System.currentTimeMillis(), null);
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage());
        }
    }

    private List<Locale> getSupportedLocales() {
        List<String> supportedLanguages = DataSourceEnum.Bundle.createProductOpt(this.dto).getSupportedLocales();
        this.logger.debug("supported languages: [{}]", (Object)supportedLanguages.toString());
        LinkedList<Locale> supportedLocales = new LinkedList<Locale>();
        for (String languageTag : supportedLanguages) {
            supportedLocales.add(Locale.forLanguageTag(languageTag));
        }
        return supportedLocales;
    }
}

