/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.api.opt.local;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.messages.api.opt.ProductOpt;
import com.vmware.vipclient.i18n.messages.dto.BaseDTO;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalProductOpt
implements ProductOpt {
    private Logger logger = LoggerFactory.getLogger(LocalProductOpt.class);
    private static final String BUNDLE_PREFIX = "messages_";
    private static final String BUNDLE_SUFFIX = ".json";
    private BaseDTO dto = null;

    public LocalProductOpt(BaseDTO dto) {
        this.dto = dto;
    }

    @Override
    public List<String> getSupportedLocales() {
        ArrayList<String> supportedLocales;
        block15: {
            supportedLocales = new ArrayList<String>();
            try {
                Path path = Paths.get(VIPCfg.getInstance().getOfflineResourcesBaseUrl(), new String[0]);
                URI uri = Thread.currentThread().getContextClassLoader().getResource(path.toString()).toURI();
                if (uri.getScheme().equals("jar")) {
                    try (FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                        path = fileSystem.getPath(path.toString(), new String[0]);
                        this.getSupportedLocales(path, supportedLocales);
                        break block15;
                    }
                }
                path = Paths.get(uri);
                this.getSupportedLocales(path, supportedLocales);
            }
            catch (Exception e) {
                this.logger.debug(e.getMessage());
            }
        }
        return supportedLocales;
    }

    @Override
    public List<String> getComponents() {
        ArrayList<String> components;
        block15: {
            components = new ArrayList<String>();
            try {
                Path path = Paths.get(VIPCfg.getInstance().getOfflineResourcesBaseUrl(), new String[0]);
                URI uri = Thread.currentThread().getContextClassLoader().getResource(path.toString()).toURI();
                if (uri.getScheme().equals("jar")) {
                    try (FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                        path = fileSystem.getPath(path.toString(), new String[0]);
                        this.getComponents(path, components);
                        break block15;
                    }
                }
                path = Paths.get(uri);
                this.getComponents(path, components);
            }
            catch (Exception e) {
                this.logger.debug(e.getMessage());
            }
        }
        return components;
    }

    private void getSupportedLocales(Path path, List<String> supportedLocales) throws IOException {
        try (Stream<Path> listOfFiles = Files.walk(path, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.getFileName().toString().startsWith(BUNDLE_PREFIX) && p.getFileName().toString().endsWith(BUNDLE_SUFFIX));){
            listOfFiles.map(file -> file.getFileName().toString().substring(BUNDLE_PREFIX.length(), file.getFileName().toString().indexOf(46))).forEach(language -> supportedLocales.add((String)language));
        }
    }

    private void getComponents(Path path, List<String> components) throws IOException {
        try (Stream<Path> listOfFiles = Files.list(path).filter(p -> !Files.isRegularFile(p, new LinkOption[0]));){
            listOfFiles.forEach(s -> components.add(s.getFileName().toString()));
        }
    }
}

