/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.service;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.cache.Cache;
import com.vmware.vipclient.i18n.base.cache.FormatCacheItem;
import com.vmware.vipclient.i18n.base.cache.TranslationCacheManager;
import com.vmware.vipclient.i18n.messages.dto.BaseDTO;
import com.vmware.vipclient.i18n.util.JSONUtils;
import java.util.Map;
import org.json.simple.JSONObject;

public class FormattingCacheService {
    public void addPatterns(String locale, JSONObject o) {
        String cacheKey = this.getPatternsCacheKey(locale);
        this.addFormattings(cacheKey, (Map<String, String>)o);
    }

    public void addPatterns(String language, String region, JSONObject o) {
        String cacheKey = this.getPatternsCacheKey(language, region);
        this.addFormattings(cacheKey, (Map<String, String>)o);
    }

    public void addSupportedLanguages(BaseDTO dto, String locale, Map<String, String> o) {
        o = JSONUtils.map2SortMap(o);
        String cacheKey = this.getSupportedLanguagesCacheKey(dto, locale);
        this.addFormattings(cacheKey, o);
    }

    public void addLanguagesNames(String locale, Map<String, String> o) {
        String cacheKey = this.getLanguagesNamesCacheKey(locale);
        this.addFormattings(cacheKey, o);
    }

    public void addRegions(String locale, Map<String, String> o) {
        o = JSONUtils.map2SortMap(o);
        String cacheKey = this.getRegionsCacheKey(locale);
        this.addFormattings(cacheKey, o);
    }

    public JSONObject getPatterns(String locale) {
        String cacheKey = this.getPatternsCacheKey(locale);
        return this.getFormattingPatterns(cacheKey);
    }

    public JSONObject getPatterns(String language, String region) {
        String cacheKey = this.getPatternsCacheKey(language, region);
        return this.getFormattingPatterns(cacheKey);
    }

    public Map<String, String> getSupportedLanguages(BaseDTO dto, String locale) {
        String cacheKey = this.getSupportedLanguagesCacheKey(dto, locale);
        return this.getFormattings(cacheKey);
    }

    public Map<String, String> getLanguagesNames(String locale) {
        String cacheKey = this.getLanguagesNamesCacheKey(locale);
        return this.getFormattings(cacheKey);
    }

    public Map<String, String> getRegions(String locale) {
        String cacheKey = this.getRegionsCacheKey(locale);
        return this.getFormattings(cacheKey);
    }

    private String getPatternsCacheKey(String locale) {
        return "patterns_" + locale;
    }

    private String getPatternsCacheKey(String language, String region) {
        return "patterns_" + language + "-" + region;
    }

    private String getSupportedLanguagesCacheKey(BaseDTO dto, String locale) {
        return "dispns_" + dto.getProductID() + "_" + dto.getVersion() + "_" + locale;
    }

    private String getLanguagesNamesCacheKey(String locale) {
        return "languages_" + locale;
    }

    private String getRegionsCacheKey(String locale) {
        return "regions_" + locale;
    }

    private JSONObject getFormattingPatterns(String key) {
        Map<String, String> o = this.getFormattings(key);
        if (o != null) {
            return new JSONObject(o);
        }
        return null;
    }

    private void addFormattings(String key, Map<String, String> o) {
        if (null != key && null != o) {
            VIPCfg.getInstance().getCacheManager();
            Cache c = TranslationCacheManager.getCache("CACHE_L2");
            if (c != null) {
                c.put(key, new FormatCacheItem(o));
            }
        }
    }

    private Map<String, String> getFormattings(String key) {
        FormatCacheItem cacheItem;
        Map<String, String> o = null;
        VIPCfg.getInstance().getCacheManager();
        Cache c = TranslationCacheManager.getCache("CACHE_L2");
        if (c != null && (cacheItem = (FormatCacheItem)c.get(key)) != null) {
            o = cacheItem.getCachedData();
        }
        return o;
    }
}

