/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.l2.service;

import com.vmware.vipclient.i18n.I18nFactory;
import com.vmware.vipclient.i18n.base.instances.PatternMessage;
import com.vmware.vipclient.i18n.l2.common.PatternCategory;
import com.vmware.vipclient.i18n.l2.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberFormatService {
    Logger logger = LoggerFactory.getLogger(NumberFormatService.class);

    public String format(Object value, Integer fractionSize, Locale locale, int style) {
        return this.format(value, null, fractionSize, locale, style);
    }

    public String format(Object value, Integer fractionSize, String language, String region, int style) {
        return this.format(value, null, fractionSize, language, region, style);
    }

    public String format(Object value, String currencyCode, Integer fractionSize, String language, String region, int style) {
        if (language == null || region == null) {
            return this.format(value, currencyCode, fractionSize, null, style);
        }
        if (null == value || "".equals(value)) {
            this.logger.info("Invalid value! ");
            return "";
        }
        if (fractionSize != null && fractionSize < 0) {
            fractionSize = 0;
        }
        JSONObject numberFormatData = null;
        I18nFactory factory = I18nFactory.getInstance();
        if (factory == null) {
            throw new RuntimeException("I18nFactory is null, please create it first!");
        }
        PatternMessage p = (PatternMessage)factory.getMessageInstance(PatternMessage.class);
        JSONObject localeFormatData = p.getPatternMessage(language, region);
        if (localeFormatData == null) {
            throw new RuntimeException("No format pattern data found for language: " + language + ", region: " + region);
        }
        if (style == 1) {
            this.validateCurrencyCode(currencyCode);
            numberFormatData = this.getCurrencyRelatedData(localeFormatData, currencyCode);
        } else {
            numberFormatData = (JSONObject)localeFormatData.get((Object)PatternCategory.NUMBERS.toString());
        }
        if (numberFormatData == null) {
            throw new RuntimeException("Can't format " + value + " without pattern data!");
        }
        NumberFormat numberFormat = NumberFormat.getInstance(numberFormatData, style);
        String formatNumber = numberFormat.format(value, fractionSize);
        if (style == 2) {
            String percentSymbol = (String)((JSONObject)numberFormatData.get((Object)"numberSymbols")).get((Object)"percentSign");
            formatNumber = formatNumber.replace(String.valueOf("%"), percentSymbol);
        } else if (style == 1) {
            JSONObject currencyData = (JSONObject)numberFormatData.get((Object)"currency");
            String currencySymbol = (String)currencyData.get((Object)"symbol");
            formatNumber = formatNumber.replace(String.valueOf('\u00a4'), currencySymbol);
        }
        return formatNumber;
    }

    public String format(Object value, String currencyCode, Integer fractionSize, Locale locale, int style) {
        if (null == value || "".equals(value)) {
            this.logger.info("Invalid value! ");
            return "";
        }
        if (fractionSize != null && fractionSize < 0) {
            fractionSize = 0;
        }
        locale = locale == null ? Locale.ENGLISH : locale;
        JSONObject numberFormatData = null;
        I18nFactory factory = I18nFactory.getInstance();
        if (factory == null) {
            throw new RuntimeException("I18nFactory is null, please create it first!");
        }
        PatternMessage p = (PatternMessage)factory.getMessageInstance(PatternMessage.class);
        JSONObject localeFormatData = p.getPatternMessage(locale);
        if (localeFormatData == null) {
            throw new RuntimeException("No format pattern data found for locale " + locale + " !");
        }
        if (style == 1) {
            this.validateCurrencyCode(currencyCode);
            numberFormatData = this.getCurrencyRelatedData(localeFormatData, currencyCode);
        } else {
            numberFormatData = (JSONObject)localeFormatData.get((Object)PatternCategory.NUMBERS.toString());
        }
        if (numberFormatData == null) {
            throw new RuntimeException("Can't format " + value + " without pattern data!");
        }
        NumberFormat numberFormat = NumberFormat.getInstance(numberFormatData, style);
        String formatNumber = numberFormat.format(value, fractionSize);
        if (style == 2) {
            String percentSymbol = (String)((JSONObject)numberFormatData.get((Object)"numberSymbols")).get((Object)"percentSign");
            formatNumber = formatNumber.replace(String.valueOf("%"), percentSymbol);
        } else if (style == 1) {
            JSONObject currencyData = (JSONObject)numberFormatData.get((Object)"currency");
            String currencySymbol = (String)currencyData.get((Object)"symbol");
            formatNumber = formatNumber.replace(String.valueOf('\u00a4'), currencySymbol);
        }
        return formatNumber;
    }

    private JSONObject getCurrencyRelatedData(JSONObject allCategoriesData, String currencyCode) {
        JSONObject currencyFormatData = new JSONObject();
        JSONObject numberFormatData = (JSONObject)allCategoriesData.get((Object)PatternCategory.NUMBERS.toString());
        JSONObject currencyData = (JSONObject)((HashMap)allCategoriesData.get((Object)"currencies")).get(currencyCode);
        if (currencyData == null) {
            throw new IllegalArgumentException("Unsupported currency code " + currencyCode + ".");
        }
        JSONObject currencySupplementalData = (JSONObject)((HashMap)allCategoriesData.get((Object)PatternCategory.SUPPLEMENTAL.toString())).get("currencies");
        JSONObject fractionData = (JSONObject)((HashMap)currencySupplementalData.get((Object)"fractions")).get(currencyCode);
        currencyFormatData.put((Object)PatternCategory.NUMBERS.toString(), (Object)numberFormatData);
        currencyFormatData.put((Object)"currency", (Object)currencyData);
        currencyFormatData.put((Object)"fraction", (Object)fractionData);
        return currencyFormatData;
    }

    public boolean validateCurrencyCode(String theISOCode) {
        if (theISOCode == null) {
            throw new NullPointerException("The input currency code is null.");
        }
        if (!NumberFormatService.isAlpha3Code(theISOCode)) {
            throw new IllegalArgumentException("The input currency code is not 3-letter alphabetic code.");
        }
        return true;
    }

    private static boolean isAlpha3Code(String code) {
        if (code.length() != 3) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            char ch = code.charAt(i);
            if (ch >= 'A' && (ch <= 'Z' || ch >= 'a') && ch <= 'z') continue;
            return false;
        }
        return true;
    }
}

