/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.api.opt.server;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.HttpRequester;
import com.vmware.vipclient.i18n.base.cache.PatternCacheItem;
import com.vmware.vipclient.i18n.messages.api.opt.PatternOpt;
import com.vmware.vipclient.i18n.messages.api.opt.server.RemoteL2BaseOpt;
import com.vmware.vipclient.i18n.messages.api.url.URLUtils;
import com.vmware.vipclient.i18n.messages.api.url.V2URL;
import java.util.Map;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotePatternOpt
extends RemoteL2BaseOpt
implements PatternOpt {
    Logger logger = LoggerFactory.getLogger(RemotePatternOpt.class);

    @Override
    public void getPatterns(String locale, PatternCacheItem cacheItem) {
        this.logger.debug("Look for pattern from Singleton Service for locale [{}]!", (Object)locale);
        HttpRequester httpRequester = VIPCfg.getInstance().getVipService().getHttpRequester();
        this.getPatternsFromRemote(locale, V2URL.getPatternURL(locale, httpRequester.getBaseURL()), "GET", null, cacheItem);
    }

    @Override
    public void getPatterns(String language, String region, PatternCacheItem cacheItem) {
        this.logger.debug("Look for pattern from Singleton Service for language [{}], region [{}]!", (Object)language, (Object)region);
        HttpRequester httpRequester = VIPCfg.getInstance().getVipService().getHttpRequester();
        this.getPatternsFromRemote(language + "-" + region, V2URL.getPatternURL(language, region, httpRequester.getBaseURL()), "GET", null, cacheItem);
    }

    private void getPatternsFromRemote(String locale, String url, String method, Object requestData, PatternCacheItem cacheItem) {
        block6: {
            Map<String, Object> response = this.getResponse(url, method, requestData, cacheItem);
            Integer responseCode = (Integer)response.get("response_code");
            if (responseCode != null && (responseCode.equals(200) || responseCode.equals(304))) {
                Long maxAgeMillis;
                long timestamp = response.get("response_timestamp") != null ? (Long)response.get("response_timestamp") : System.currentTimeMillis();
                String etag = URLUtils.createEtagString((Map)response.get("headers"));
                Long l = maxAgeMillis = response.get("max-age") != null ? (Long)response.get("max-age") : null;
                if (responseCode.equals(200)) {
                    try {
                        String responseBody = (String)response.get("body");
                        Map<String, Object> patterns = this.getPatternsFromResponse(responseBody);
                        if (patterns != null) {
                            this.logger.debug("Found the pattern from Singleton Service for locale [{}].\n", (Object)locale);
                            cacheItem.set(patterns, etag, timestamp, maxAgeMillis);
                            break block6;
                        }
                        this.logger.debug("Didn't find the pattern from Singleton Service for locale [{}].\n", (Object)locale);
                        cacheItem.set(etag, timestamp, maxAgeMillis);
                    }
                    catch (Exception e) {
                        this.logger.error("Failed to get pattern data from remote!");
                    }
                } else {
                    this.logger.debug("There is no update on Singleton Service for the pattern of locale [{}].\n", (Object)locale);
                    cacheItem.set(etag, timestamp, maxAgeMillis);
                }
            }
        }
    }

    private Map<String, Object> getPatternsFromResponse(String responseBody) {
        Object obj;
        Map categoriesObj = null;
        Map dataObj = (Map)this.getDataFromResponse(responseBody);
        if (dataObj != null && dataObj instanceof JSONObject && (obj = dataObj.get("categories")) != null && obj instanceof JSONObject) {
            categoriesObj = (Map)obj;
        }
        return categoriesObj;
    }
}

