/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.filters;

import com.vmware.vipclient.i18n.I18nFactory;
import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.cache.MessageCache;
import com.vmware.vipclient.i18n.base.instances.TranslationMessage;
import com.vmware.vipclient.i18n.exceptions.VIPClientInitException;
import com.vmware.vipclient.i18n.exceptions.VIPJavaClientException;
import com.vmware.vipclient.i18n.filters.FilterUtils;
import com.vmware.vipclient.i18n.util.LocaleUtility;
import com.vmware.vipclient.i18n.util.StringUtil;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VIPComponentFilter
implements Filter {
    private Logger logger = LoggerFactory.getLogger(VIPComponentFilter.class);
    private TranslationMessage translation;
    private VIPCfg gc = VIPCfg.getInstance();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            Map<String, String> ctmap;
            String component = FilterUtils.getParamFromURI(request, "component");
            this.logger.debug("component: " + component);
            String locale = FilterUtils.getParamFromQuery(request, "locale");
            this.logger.debug("locale: " + locale);
            String messages = "{}";
            if (!(StringUtil.isEmpty(component) || StringUtil.isEmpty(locale) || LocaleUtility.isDefaultLocale(locale) || this.translation == null || (ctmap = this.translation.getMessages(LocaleUtility.fmtToMappedLocale(locale), component)) == null)) {
                messages = JSONObject.toJSONString(ctmap);
            }
            ServletOutputStream os = response.getOutputStream();
            response.setContentType("text/javascript;charset=UTF-8");
            VIPComponentFilter vIPComponentFilter = this;
            VIPComponentFilter vIPComponentFilter2 = this;
            VIPComponentFilter vIPComponentFilter3 = this;
            VIPComponentFilter vIPComponentFilter4 = this;
            VIPComponentFilter vIPComponentFilter5 = this;
            os.write(("var translation = {\"messages\" : " + messages + ", \"productName\" : \"" + vIPComponentFilter.gc.getInstance().getProductName() + "\", \"version\" : \"" + vIPComponentFilter2.gc.getInstance().getVersion() + "\", \"vipServer\" : \"" + vIPComponentFilter3.gc.getInstance().getVipServer() + "\", \"pseudo\" : \"" + vIPComponentFilter4.gc.getInstance().isPseudo() + "\", \"collectSource\" : \"" + vIPComponentFilter5.gc.getInstance().isCollectSource() + "\"};").getBytes("UTF-8"));
        }
        catch (VIPJavaClientException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            String errorMsg = "{\"code\":400, \"message\": \"" + e.getMessage() + "\"}";
            FilterUtils.printErrorMsg(response, errorMsg);
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        if (this.gc.getVipService() == null) {
            try {
                this.gc.initialize("vipconfig");
            }
            catch (VIPClientInitException e) {
                this.logger.error(e.getMessage());
            }
            this.gc.initializeVIPService();
        }
        this.gc.createTranslationCache(MessageCache.class);
        I18nFactory i18n = I18nFactory.getInstance(this.gc);
        this.translation = (TranslationMessage)i18n.getMessageInstance(TranslationMessage.class);
    }
}

