package com.vmware.vcloud.rest.openapi.api;

/*-
 * #%L
 * vcd-api-bindings-java :: vCloud Director REST API bindings
 * %%
 * Copyright (C) 2013 - 2019 VMware
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

import com.vmware.vcloud.rest.openapi.model.ExecutionContext;
import com.vmware.vcloud.rest.openapi.model.ExecutionState;
import com.vmware.vcloud.rest.openapi.model.ParameterTypes;
import com.vmware.vcloud.rest.openapi.model.PresentationExecutionsList;
import com.vmware.vcloud.rest.openapi.model.SupportedConstraints;
import com.vmware.vcloud.rest.openapi.model.SupportedDecorators;
import com.vmware.vcloud.rest.openapi.model.SupportedPresentationElements;
import com.vmware.vcloud.rest.openapi.model.WsWorkflowExecution;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.*;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.MediaType;
import org.apache.cxf.jaxrs.ext.multipart.*;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ApiResponse;
import io.swagger.jaxrs.PATCH;
import javax.validation.constraints.*;
import javax.validation.Valid;

@Path("/")
@Api(value = "/", description = "")
public interface VroWorkflowExecutionApi  {

    @DELETE
    @Path("/workflows/{workflowId}/executions/{executionId}/state")
    @ApiOperation(value = "Cancel workflow run", tags={ "vroWorkflowExecution",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 204, message = "No content. Workflow execution has been cancelled"),
        @ApiResponse(code = 400, message = "The request is invalid(validation error)"),
        @ApiResponse(code = 401, message = "The user is not authorized"),
        @ApiResponse(code = 403, message = "Forbidden"),
        @ApiResponse(code = 404, message = "Can not find a workflow with the specified ID or the user does not have 'read' access rights for that workflow") })
    public void cancelWorkflowExecution(@PathParam("workflowId") String workflowId, @PathParam("executionId") String executionId);

    @DELETE
    @Path("/workflows/{workflowId}/executions/{executionId}")
    @ApiOperation(value = "Delete workflow run", tags={ "vroWorkflowExecution",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 204, message = "No content. Workflow run has been deleted"),
        @ApiResponse(code = 400, message = "The request is invalid(validation error)"),
        @ApiResponse(code = 401, message = "The user is not authorized"),
        @ApiResponse(code = 403, message = "Forbidden"),
        @ApiResponse(code = 404, message = "Can not find a workflow with the specified ID or the user does not have 'read' access rights for that workflow") })
    public void deleteWorkflowExecution(@PathParam("workflowId") String workflowId, @PathParam("executionId") String executionId);

    @GET
    @Path("/workflows/{workflowId}/executions")
    @Produces({ "application/json" })
    @ApiOperation(value = "Get all executions", tags={ "vroWorkflowExecution",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Workflow executions successfully retrieved", response = PresentationExecutionsList.class),
        @ApiResponse(code = 401, message = "The user is not authorized to retrieve workflow executions"),
        @ApiResponse(code = 403, message = "Forbidden"),
        @ApiResponse(code = 404, message = "Cannot find a workflow with the specified ID or the user does not have 'read' access rights for that workflow") })
    public PresentationExecutionsList getAllWorkflowExecutions(@PathParam("workflowId") String workflowId);

    @GET
    @Path("/workflows/parameterTypes")
    @Produces({ "application/json" })
    @ApiOperation(value = "Get a list of supported parameter types", tags={ "vroWorkflowExecution",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The request is successful", response = ParameterTypes.class),
        @ApiResponse(code = 401, message = "The user is not authorized"),
        @ApiResponse(code = 403, message = "Forbidden") })
    public ParameterTypes getParameterTypes();

    @GET
    @Path("/workflows/decorators")
    @Produces({ "application/json" })
    @ApiOperation(value = "Get a list of supported decorators", tags={ "vroWorkflowExecution",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The request is successful", response = SupportedDecorators.class),
        @ApiResponse(code = 401, message = "The user is not authorized"),
        @ApiResponse(code = 403, message = "Forbidden") })
    public SupportedDecorators getSupportedDecorators();

    @GET
    @Path("/workflows/presentationElements")
    @Produces({ "application/json" })
    @ApiOperation(value = "Get a list of supported presentation elements", tags={ "vroWorkflowExecution",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The request is successful", response = SupportedPresentationElements.class),
        @ApiResponse(code = 401, message = "The user is not authorized"),
        @ApiResponse(code = 403, message = "Forbidden") })
    public SupportedPresentationElements getSupportedPresentationElements();

    @GET
    @Path("/workflows/constraints")
    @Produces({ "application/json" })
    @ApiOperation(value = "Get a list of supported constraints", tags={ "vroWorkflowExecution",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The request is successful", response = SupportedConstraints.class),
        @ApiResponse(code = 401, message = "The user is not authorized"),
        @ApiResponse(code = 403, message = "Forbidden") })
    public SupportedConstraints getSupportedconstraints();

    @GET
    @Path("/workflows/{workflowId}/executions/{executionId}")
    @Produces({ "application/json" })
    @ApiOperation(value = "Get workflow execution", tags={ "vroWorkflowExecution",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Workflow execution successfully retrived", response = WsWorkflowExecution.class),
        @ApiResponse(code = 400, message = "The request is invalid(validation error)"),
        @ApiResponse(code = 401, message = "The user is not authorized"),
        @ApiResponse(code = 403, message = "Forbidden"),
        @ApiResponse(code = 404, message = "Cannot find a workflow with the specified ID or the user does not have 'read' access rights for that workflow") })
    public WsWorkflowExecution getWorkflowExecution(@PathParam("workflowId") String workflowId, @PathParam("executionId") String executionId);

    @GET
    @Path("/workflows/{workflowId}/executions/{executionId}/state")
    @Produces({ "application/json" })
    @ApiOperation(value = "Get workflow execution state", tags={ "vroWorkflowExecution",  })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The request is successful", response = ExecutionState.class),
        @ApiResponse(code = 401, message = "The user is not authorized"),
        @ApiResponse(code = 403, message = "Forbidden"),
        @ApiResponse(code = 404, message = "Cannot find a workflow with the specified ID or the user does not have 'read' access rights for that workflow") })
    public ExecutionState getWorkflowExecutionState(@PathParam("workflowId") String workflowId, @PathParam("executionId") String executionId);

    @POST
    @Path("/workflows/{workflowId}/executions")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @ApiOperation(value = "Start workflow execution", tags={ "vroWorkflowExecution" })
    @ApiResponses(value = { 
        @ApiResponse(code = 201, message = "Workflow execution instance has been created", response = WsWorkflowExecution.class),
        @ApiResponse(code = 400, message = "The request is invalid(validation error)"),
        @ApiResponse(code = 401, message = "The user is not authorized"),
        @ApiResponse(code = 403, message = "Forbidden"),
        @ApiResponse(code = 404, message = "Cannot find a workflow with the specified ID or the user does not have 'read' access rights for that workflow") })
    public WsWorkflowExecution startWorkflowExecution(@PathParam("workflowId") String workflowId, @Valid ExecutionContext executionContext);
}

