package com.vmware.vcloud.rest.openapi.model;

/*-
 * #%L
 * vcd-api-bindings-java :: vCloud Director REST API bindings
 * %%
 * Copyright (C) 2013 - 2019 VMware
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.vmware.vcloud.rest.openapi.model.Constraint;
import com.vmware.vcloud.rest.openapi.model.Decorator;
import com.vmware.vcloud.rest.openapi.model.PresentationElement;
import com.vmware.vcloud.rest.openapi.model.PresentationMessageInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * Field
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-01-11T04:46:40.806Z")

public class Field extends PresentationElement  {
  @JsonProperty("decorators")
  private List<Decorator> decorators = null;

  @JsonProperty("constraints")
  private List<Constraint> constraints = null;

  @JsonProperty("type")
  private String type = null;

  @JsonProperty("affectedFieldsIds")
  private List<String> affectedFieldsIds = null;

  public Field decorators(List<Decorator> decorators) {
    this.decorators = decorators;
    return this;
  }

  public Field addDecoratorsItem(Decorator decoratorsItem) {
    if (this.decorators == null) {
      this.decorators = new ArrayList<Decorator>();
    }
    this.decorators.add(decoratorsItem);
    return this;
  }

   /**
   * Get decorators
   * @return decorators
  **/
  @ApiModelProperty(value = "")

  @Valid

  public List<Decorator> getDecorators() {
    return decorators;
  }

  public void setDecorators(List<Decorator> decorators) {
    this.decorators = decorators;
  }

  public Field constraints(List<Constraint> constraints) {
    this.constraints = constraints;
    return this;
  }

  public Field addConstraintsItem(Constraint constraintsItem) {
    if (this.constraints == null) {
      this.constraints = new ArrayList<Constraint>();
    }
    this.constraints.add(constraintsItem);
    return this;
  }

   /**
   * Get constraints
   * @return constraints
  **/
  @ApiModelProperty(value = "")

  @Valid

  public List<Constraint> getConstraints() {
    return constraints;
  }

  public void setConstraints(List<Constraint> constraints) {
    this.constraints = constraints;
  }

  public Field type(String type) {
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(value = "")


  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public Field affectedFieldsIds(List<String> affectedFieldsIds) {
    this.affectedFieldsIds = affectedFieldsIds;
    return this;
  }

  public Field addAffectedFieldsIdsItem(String affectedFieldsIdsItem) {
    if (this.affectedFieldsIds == null) {
      this.affectedFieldsIds = new ArrayList<String>();
    }
    this.affectedFieldsIds.add(affectedFieldsIdsItem);
    return this;
  }

   /**
   * Get affectedFieldsIds
   * @return affectedFieldsIds
  **/
  @ApiModelProperty(value = "")


  public List<String> getAffectedFieldsIds() {
    return affectedFieldsIds;
  }

  public void setAffectedFieldsIds(List<String> affectedFieldsIds) {
    this.affectedFieldsIds = affectedFieldsIds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Field field = (Field) o;
    return Objects.equals(this.decorators, field.decorators) &&
        Objects.equals(this.constraints, field.constraints) &&
        Objects.equals(this.type, field.type) &&
        Objects.equals(this.affectedFieldsIds, field.affectedFieldsIds) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(decorators, constraints, type, affectedFieldsIds, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Field {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    decorators: ").append(toIndentedString(decorators)).append("\n");
    sb.append("    constraints: ").append(toIndentedString(constraints)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    affectedFieldsIds: ").append(toIndentedString(affectedFieldsIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

