package com.vmware.vcloud.rest.openapi.model;

/*-
 * #%L
 * vcd-api-bindings-java :: vCloud Director REST API bindings
 * %%
 * Copyright (C) 2013 - 2019 VMware
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.vmware.vcloud.rest.openapi.model.QueryDetails;
import com.vmware.vcloud.rest.openapi.model.QueryResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * Base query results, encapsulating page information and the query. 
 */
@ApiModel(description = "Base query results, encapsulating page information and the query. ")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-01-11T04:46:40.806Z")

public class QueryResults   {
  @JsonProperty("query")
  private QueryDetails query = null;

  @JsonProperty("results")
  private List<QueryResult> results = null;

  @JsonProperty("resultTotal")
  private Integer resultTotal = null;

  @JsonProperty("pageCount")
  private Integer pageCount = null;

  public QueryResults query(QueryDetails query) {
    this.query = query;
    return this;
  }

   /**
   * Get query
   * @return query
  **/
  @ApiModelProperty(value = "")

  @Valid

  public QueryDetails getQuery() {
    return query;
  }

  public void setQuery(QueryDetails query) {
    this.query = query;
  }

  public QueryResults results(List<QueryResult> results) {
    this.results = results;
    return this;
  }

  public QueryResults addResultsItem(QueryResult resultsItem) {
    if (this.results == null) {
      this.results = new ArrayList<QueryResult>();
    }
    this.results.add(resultsItem);
    return this;
  }

   /**
   * The returned objects from this query.
   * @return results
  **/
  @ApiModelProperty(value = "The returned objects from this query.")

  @Valid

  public List<QueryResult> getResults() {
    return results;
  }

  public void setResults(List<QueryResult> results) {
    this.results = results;
  }

  public QueryResults resultTotal(Integer resultTotal) {
    this.resultTotal = resultTotal;
    return this;
  }

   /**
   * How many results there are in total (i.e., considering all pages).
   * @return resultTotal
  **/
  @ApiModelProperty(value = "How many results there are in total (i.e., considering all pages).")


  public Integer getResultTotal() {
    return resultTotal;
  }

  public void setResultTotal(Integer resultTotal) {
    this.resultTotal = resultTotal;
  }

  public QueryResults pageCount(Integer pageCount) {
    this.pageCount = pageCount;
    return this;
  }

   /**
   * How many pages there are in total.
   * @return pageCount
  **/
  @ApiModelProperty(value = "How many pages there are in total.")


  public Integer getPageCount() {
    return pageCount;
  }

  public void setPageCount(Integer pageCount) {
    this.pageCount = pageCount;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QueryResults queryResults = (QueryResults) o;
    return Objects.equals(this.query, queryResults.query) &&
        Objects.equals(this.results, queryResults.results) &&
        Objects.equals(this.resultTotal, queryResults.resultTotal) &&
        Objects.equals(this.pageCount, queryResults.pageCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(query, results, resultTotal, pageCount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QueryResults {\n");
    
    sb.append("    query: ").append(toIndentedString(query)).append("\n");
    sb.append("    results: ").append(toIndentedString(results)).append("\n");
    sb.append("    resultTotal: ").append(toIndentedString(resultTotal)).append("\n");
    sb.append("    pageCount: ").append(toIndentedString(pageCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

